<?php
return array(
    'zf-mvc-auth' => array(
        'user_table' => 'pr_user',
        'authentication' => array(
            'adapters' => array(
                'oauth2' => array(
                    'adapter' => 'ZF\\MvcAuth\\Authentication\\OAuth2Adapter',
                    'storage' => array(
                        'storage' => 'Resrequest\\API\\Authentication\\OAuth2Adapter',
                        'route' => '/oauth',
                    ),
                ),
            ),
            'map' => array(
                'Resrequest\\API\\V1' => 'oauth2',
            ),
        ),
        'authorization' => array(
            'Resrequest\\API\\V1\\Rpc\\Ping\\Controller' => array(
                'actions' => array(
                    'ping' => array(
                        'GET' => false,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller' => array(
                'actions' => array(
                    'authorisationGetAccess' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\Chart\\Controller' => array(
                'actions' => array(
                    'chart' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller' => array(
                'actions' => array(
                    'remindersCountReminder' => array(
                        'GET' => false,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller' => array(
                'actions' => array(
                    'remindersAddReminder' => array(
                        'GET' => false,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller' => array(
                'actions' => array(
                    'remindersSendReminders' => array(
                        'GET' => false,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Controller' => array(
                'actions' => array(
                    'financialInterfaceSaveOptions' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Controller' => array(
                'actions' => array(
                    'financialInterfaceGetOptions' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rest\\Chart\\Controller' => array(
                'collection' => array(
                    'GET' => false,
                    'POST' => false,
                    'PUT' => false,
                    'PATCH' => false,
                    'DELETE' => false,
                ),
                'entity' => array(
                    'GET' => true,
                    'POST' => false,
                    'PUT' => false,
                    'PATCH' => false,
                    'DELETE' => false,
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Controller' => array(
                'actions' => array(
                    'chartBuilder' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rest\\ChartContainer\\Controller' => array(
                'collection' => array(
                    'GET' => false,
                    'POST' => false,
                    'PUT' => false,
                    'PATCH' => false,
                    'DELETE' => false,
                ),
                'entity' => array(
                    'GET' => true,
                    'POST' => false,
                    'PUT' => false,
                    'PATCH' => false,
                    'DELETE' => false,
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\Controller' => array(
                'actions' => array(
                    'resVegaGetAccess' => array(
                        'GET' => false,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller' => array(
                'actions' => array(
                    'resVegaSetAccess' => array(
                        'GET' => false,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\Controller' => array(
                'actions' => array(
                    'chartGetAccess' => array(
                        'GET' => true,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller' => array(
                'actions' => array(
                    'resVegaSignUp' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\Controller' => array(
                'actions' => array(
                    'resVegaGetReports' => array(
                        'GET' => true,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller' => array(
                'actions' => array(
                    'minLosGetRule' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller' => array(
                'actions' => array(
                    'minLosGetMinLos' => array(
                        'GET' => false,
                        'POST' => false,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller' => array(
                'actions' => array(
                    'minLosDeleteRule' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller' => array(
                'actions' => array(
                    'minLosEditRule' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\Controller' => array(
                'actions' => array(
                    'minLosAddRule' => array(
                        'GET' => false,
                        'POST' => true,
                        'PUT' => false,
                        'PATCH' => false,
                        'DELETE' => false,
                    ),
                ),
            ),
        ),
    ),
    'controllers' => array(
        'factories' => array(
            'Resrequest\\API\\V1\\Rpc\\Ping\\Controller' => 'Resrequest\\API\\V1\\Rpc\\Ping\\PingControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRooms\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetRooms\\RoomingGetRoomsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetItems\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetItems\\RoomingGetItemsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItems\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingSetItems\\RoomingSetItemsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetDefaultRate\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetDefaultRate\\RoomingGetDefaultRateControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller' => 'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\AuthorisationGetAccessControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\Chart\\Controller' => 'Resrequest\\API\\V1\\Rpc\\Chart\\ChartControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Controller' => 'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\OauthTokenRefreshControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\RemindersAddReminderControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\RemindersEditReminderControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\RemindersDeleteReminderControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\RemindersGetReminderControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\RemindersGetReferToControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\ReminderGetUserEmailControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\RemindersCountReminderControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\RemindersSendRemindersControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersReport\\RemindersReportControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\NotificationsGetUsers\\Controller' => 'Resrequest\\API\\V1\\Rpc\\NotificationsGetUsers\\NotificationsGetUsersControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\NotificationGetReceipts\\Controller' => 'Resrequest\\API\\V1\\Rpc\\NotificationGetReceipts\\NotificationGetReceiptsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\NotificationAddNotification\\Controller' => 'Resrequest\\API\\V1\\Rpc\\NotificationAddNotification\\NotificationAddNotificationControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetStock\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetStock\\RoomingGetStockControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRateAmount\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetRateAmount\\RoomingGetRateAmountControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItem\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingSetItem\\RoomingSetItemControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\ChartBuilderControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Controller' => 'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\FinancialInterfaceGetOptionsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Controller' => 'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\FinancialInterfaceSaveOptionsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\SystemInfo\\Controller' => 'Resrequest\\API\\V1\\Rpc\\SystemInfo\\SystemInfoControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\SystemDiagnostics\\Controller' => 'Resrequest\\API\\V1\\Rpc\\SystemDiagnostics\\SystemDiagnosticsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\FilterGetPropertyAccomm\\Controller' => 'Resrequest\\API\\V1\\Rpc\\FilterGetPropertyAccomm\\FilterGetPropertyAccommControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ReservationGetDetails\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ReservationGetDetails\\ReservationGetDetailsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\BusinessStructureGetProperties\\Controller' => 'Resrequest\\API\\V1\\Rpc\\BusinessStructureGetProperties\\BusinessStructureGetPropertiesControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ReservationGetReservation\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ReservationGetReservation\\ReservationGetReservationControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\ResVegaGetAccessControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\ResVegaSetAccessControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\ChartGetAccessControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\ResVegaSignUpControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\Controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\ResVegaGetReportsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\PublicGetReservation\\Controller' => 'Resrequest\\API\\V1\\Rpc\\PublicGetReservation\\PublicGetReservationControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\PublicSaveGuests\\Controller' => 'Resrequest\\API\\V1\\Rpc\\PublicSaveGuests\\PublicSaveGuestsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuests\\Controller' => 'Resrequest\\API\\V1\\Rpc\\PublicGetGuests\\PublicGetGuestsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\PublicCheckInGuests\\Controller' => 'Resrequest\\API\\V1\\Rpc\\PublicCheckInGuests\\PublicCheckInGuestsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuestSettings\\Controller' => 'Resrequest\\API\\V1\\Rpc\\PublicGetGuestSettings\\PublicGetGuestSettingsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\WorkflowsAddWorkflowControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\WorkflowsEditWorkflowControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\WorkflowsDeleteWorkflowControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\WorkflowsGetWorkflowControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\WorkflowsGetWorkflowTriggerControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\WorkflowsRunWorkflowControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\MinLosGetMinLosControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\MinLosGetRuleControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\MinLosDeleteRuleControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\MinLosEditRuleControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\Controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\MinLosAddRuleControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\SystemScripts\\Controller' => 'Resrequest\\API\\V1\\Rpc\\SystemScripts\\SystemScriptsControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\RemindersStopReminders\\Controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersStopReminders\\RemindersStopRemindersControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\SystemCommand\\Controller' => 'Resrequest\\API\\V1\\Rpc\\SystemCommand\\SystemCommandControllerFactory',
            'Resrequest\\API\\V1\\Rpc\\Imageset\\Controller' => 'Resrequest\\API\\V1\\Rpc\\Imageset\\ImagesetControllerFactory',
        ),
    ),
    'router' => array(
        'routes' => array(
            'resrequest-api.rpc.ping' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/ping',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\Ping\\Controller',
                        'action' => 'ping',
                    ),
                ),
            ),
            'resrequest-api.rpc.rooming-get-rooms' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/rooming/get_rooms',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetRooms\\Controller',
                        'action' => 'roomingGetRooms',
                    ),
                ),
            ),
            'resrequest-api.rpc.rooming-get-items' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/rooming/get_items',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetItems\\Controller',
                        'action' => 'roomingGetItems',
                    ),
                ),
            ),
            'resrequest-api.rpc.rooming-set-items' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/rooming/set_items',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingSetItems\\Controller',
                        'action' => 'roomingSetItems',
                    ),
                ),
            ),
            'resrequest-api.rpc.rooming-get-default-rate' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/rooming/get_default_rate',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetDefaultRate\\Controller',
                        'action' => 'roomingGetDefaultRate',
                    ),
                ),
            ),
            'resrequest-api.rpc.authorisation-get-access' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/authorisation/get_access',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller',
                        'action' => 'authorisationGetAccess',
                    ),
                ),
            ),
            'resrequest-api.rpc.chart' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/chart',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\Chart\\Controller',
                        'action' => 'chart',
                    ),
                ),
            ),
            'resrequest-api.rpc.oauth-token-refresh' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/oauth/token/refresh',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Controller',
                        'action' => 'oauthTokenRefresh',
                    ),
                ),
            ),
            'resrequest-api.rpc.rooming-get-stock' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/rooming/get_stock',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetStock\\Controller',
                        'action' => 'roomingGetStock',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-add-reminder' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/add_reminder',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller',
                        'action' => 'remindersAddReminder',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-edit-reminder' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/edit_reminder',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Controller',
                        'action' => 'remindersEditReminder',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-delete-reminder' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/delete_reminder',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Controller',
                        'action' => 'remindersDeleteReminder',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-get-reminder' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/get_reminder',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Controller',
                        'action' => 'remindersGetReminder',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-get-refer-to' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/get_refer_to',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Controller',
                        'action' => 'remindersGetReferTo',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminder-get-user-email' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/get_user_email',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Controller',
                        'action' => 'reminderGetUserEmail',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-count-reminder' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/count_reminders',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller',
                        'action' => 'remindersCountReminder',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-send-reminders' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/send_reminders',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller',
                        'action' => 'remindersSendReminders',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-report' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/report',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Controller',
                        'action' => 'remindersReport',
                    ),
                ),
            ),
            'resrequest-api.rpc.notifications-get-users' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/notifications/get_users',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\NotificationsGetUsers\\Controller',
                        'action' => 'notificationsGetUsers',
                    ),
                ),
            ),
            'resrequest-api.rpc.notification-get-receipts' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/notifications/get_receipts',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\NotificationGetReceipts\\Controller',
                        'action' => 'notificationGetReceipts',
                    ),
                ),
            ),
            'resrequest-api.rpc.notification-add-notification' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/notifications/add_notification',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\NotificationAddNotification\\Controller',
                        'action' => 'notificationAddNotification',
                    ),
                ),
            ),
            'resrequest-api.rpc.rooming-get-rate-amount' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/rooming/get_rate_amount',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingGetRateAmount\\Controller',
                        'action' => 'roomingGetRateAmount',
                    ),
                ),
            ),
            'resrequest-api.rpc.rooming-set-item' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/rooming/set_item',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RoomingSetItem\\Controller',
                        'action' => 'roomingSetItem',
                    ),
                ),
            ),
            'resrequest-api.rpc.system-info' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/systeminfo',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\SystemInfo\\Controller',
                        'action' => 'systemInfo',
                    ),
                ),
            ),
            'resrequest-api.rpc.system-diagnostics' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/systemdiagnostics',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\SystemDiagnostics\\Controller',
                        'action' => 'systemDiagnostics',
                    ),
                ),
            ),
            'resrequest-api.rpc.financial-interface-get-options' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/financial_interface/get_options',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Controller',
                        'action' => 'financialInterfaceGetOptions',
                    ),
                ),
            ),
            'resrequest-api.rpc.financial-interface-save-options' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/financial_interface/save_options',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Controller',
                        'action' => 'financialInterfaceSaveOptions',
                    ),
                ),
            ),
            'resrequest\\api.rest.chart' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/chart[/:chart_id]',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rest\\Chart\\Controller',
                    ),
                ),
            ),
            'resrequest\\api.rest.chart-container' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/chart-container[/:chart_container_id]',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rest\\ChartContainer\\Controller',
                    ),
                ),
            ),
            'resrequest-api.rpc.chart-builder' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/chart-builder',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Controller',
                        'action' => 'chartBuilder',
                    ),
                ),
            ),
            'resrequest-api.rpc.filter-get-property-accomm' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/filters/get_property_accomm',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\FilterGetPropertyAccomm\\Controller',
                        'action' => 'filterGetPropertyAccomm',
                    ),
                ),
            ),
            'resrequest-api.rpc.reservation-get-details' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reservation/get_details',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ReservationGetDetails\\Controller',
                        'action' => 'reservationGetDetails',
                    ),
                ),
            ),
            'resrequest-api.rpc.business-structure-get-properties' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/business_structure/get_properties',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\BusinessStructureGetProperties\\Controller',
                        'action' => 'businessStructureGetProperties',
                    ),
                ),
            ),
            'resrequest-api.rpc.reservation-get-reservation' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reservation/get_reservations',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ReservationGetReservation\\Controller',
                        'action' => 'reservationGetReservation',
                    ),
                ),
            ),
            'resrequest-api.rpc.res-vega-get-access' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/resvega/get_access',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\Controller',
                        'action' => 'resVegaGetAccess',
                    ),
                ),
            ),
            'resrequest-api.rpc.res-vega-set-access' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/resvega/set_access',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller',
                        'action' => 'resVegaSetAccess',
                    ),
                ),
            ),
            'resrequest-api.rpc.chart-get-access' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/chart/get_access',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\Controller',
                        'action' => 'chartGetAccess',
                    ),
                ),
            ),
            'resrequest-api.rpc.res-vega-sign-up' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/resvega/sign_up',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller',
                        'action' => 'resVegaSignUp',
                    ),
                ),
            ),
            'resrequest-api.rpc.res-vega-get-reports' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/resvega/get_reports',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\Controller',
                        'action' => 'resVegaGetReports',
                    ),
                ),
            ),
            'resrequest-api.rpc.public-get-reservation' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/public/get_reservation',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\PublicGetReservation\\Controller',
                        'action' => 'publicGetReservation',
                    ),
                ),
            ),
            'resrequest-api.rpc.public-save-guests' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/public/save_guests',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\PublicSaveGuests\\Controller',
                        'action' => 'publicSaveGuests',
                    ),
                ),
            ),
            'resrequest-api.rpc.public-get-guests' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/public/get_guests',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\PublicGetGuests\\Controller',
                        'action' => 'publicGetGuests',
                    ),
                ),
            ),
            'resrequest-api.rpc.public-check-in-guests' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/public/check_in_guests',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\PublicCheckInGuests\\Controller',
                        'action' => 'publicCheckInGuests',
                    ),
                ),
            ),
            'resrequest-api.rpc.public-get-guest-settings' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/public/get_guest_settings',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\PublicGetGuestSettings\\Controller',
                        'action' => 'publicGetGuestSettings',
                    ),
                ),
            ),
            'resrequest-api.rpc.workflows-add-workflow' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/workflows/add_workflow',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Controller',
                        'action' => 'workflowsAddWorkflow',
                    ),
                ),
            ),
            'resrequest-api.rpc.workflows-edit-workflow' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/workflows/edit_workflow',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Controller',
                        'action' => 'workflowsEditWorkflow',
                    ),
                ),
            ),
            'resrequest-api.rpc.workflows-delete-workflow' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/workflows/delete_workflow',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Controller',
                        'action' => 'workflowsDeleteWorkflow',
                    ),
                ),
            ),
            'resrequest-api.rpc.workflows-get-workflow' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/workflows/get_workflow',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Controller',
                        'action' => 'workflowsGetWorkflow',
                    ),
                ),
            ),
            'resrequest-api.rpc.workflows-get-workflow-trigger' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/workflows/get_workflow_trigger',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Controller',
                        'action' => 'workflowsGetWorkflowTrigger',
                    ),
                ),
            ),
            'resrequest-api.rpc.workflows-run-workflow' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/workflows/run_workflow',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Controller',
                        'action' => 'workflowsRunWorkflow',
                    ),
                ),
            ),
            'resrequest-api.rpc.system-scripts' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/systemscripts',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\SystemScripts\\Controller',
                        'action' => 'systemScripts',
                    ),
                ),
            ),
            'resrequest-api.rpc.min-los-get-min-los' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/minlos/get_minlos',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller',
                        'action' => 'minLosGetMinLos',
                    ),
                ),
            ),
            'resrequest-api.rpc.min-los-get-rule' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/minlos/get_rule',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller',
                        'action' => 'minLosGetRule',
                    ),
                ),
            ),
            'resrequest-api.rpc.min-los-delete-rule' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/minlos/delete_rule',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller',
                        'action' => 'minLosDeleteRule',
                    ),
                ),
            ),
            'resrequest-api.rpc.min-los-edit-rule' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/minlos/edit_rule',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller',
                        'action' => 'minLosEditRule',
                    ),
                ),
            ),
            'resrequest-api.rpc.min-los-add-rule' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/minlos/add_rule',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\Controller',
                        'action' => 'minLosAddRule',
                    ),
                ),
            ),
            'resrequest-api.rpc.reminders-stop-reminders' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/reminders/stop_reminder',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\RemindersStopReminders\\Controller',
                        'action' => 'remindersStopReminders',
                    ),
                ),
            ),
            'resrequest-api.rpc.system-command' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/systemcommand',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\SystemCommand\\Controller',
                        'action' => 'systemCommand',
                    ),
                ),
            ),
            'resrequest-api.rpc.imageset' => array(
                'type' => 'Segment',
                'options' => array(
                    'route' => '/api/v1/imageset',
                    'defaults' => array(
                        'controller' => 'Resrequest\\API\\V1\\Rpc\\Imageset\\Controller',
                        'action' => 'imageset',
                    ),
                ),
            ),
        ),
    ),
    'zf-versioning' => array(
        'uri' => array(
            0 => 'resrequest-api.rpc.ping',
            1 => 'resrequest-api.rpc.rooming-get-rooms',
            2 => 'resrequest-api.rpc.rooming-get-items',
            3 => 'resrequest-api.rpc.rooming-set-items',
            4 => 'resrequest-api.rpc.rooming-get-default-rate',
            5 => 'resrequest-api.rpc.authorisation-get-access',
            6 => 'resrequest-api.rpc.chart',
            7 => 'resrequest-api.rpc.oauth-token-refresh',
            8 => 'resrequest-api.rpc.reminders-add-reminder',
            9 => 'resrequest-api.rpc.reminders-edit-reminder',
            10 => 'resrequest-api.rpc.reminders-delete-reminder',
            11 => 'resrequest-api.rpc.reminders-get-reminder',
            12 => 'resrequest-api.rpc.reminders-get-refer-to',
            13 => 'resrequest-api.rpc.reminder-get-user-email',
            14 => 'resrequest-api.rpc.reminders-count-reminder',
            15 => 'resrequest-api.rpc.reminders-send-reminders',
            16 => 'resrequest-api.rpc.reminders-report',
            17 => 'resrequest-api.rpc.rooming-get-stock',
            18 => 'resrequest-api.rpc.rooming-get-stock',
            19 => 'resrequest-api.rpc.financial-interface-get-options',
            20 => 'resrequest-api.rpc.financial-interface-save-options',
            21 => 'resrequest-api.rpc.rooming-get-stock',
            22 => 'resrequest-api.rpc.rooming-get-rate-amount',
            23 => 'resrequest-api.rpc.rooming-set-item',
            24 => 'resrequest-api.rpc.notifications-get-users',
            25 => 'resrequest-api.rpc.notification-get-receipts',
            26 => 'resrequest-api.rpc.notification-add-notification',
            27 => 'resrequest-api.rpc.system-info',
            28 => 'resrequest-api.rpc.system-diagnostics',
            29 => 'resrequest-api.rpc.rooming-get-stock',
            30 => 'resrequest-api.rpc.rooming-get-rate-amount',
            31 => 'resrequest-api.rpc.rooming-set-item',
            32 => 'resrequest\\api.rest.chart',
            33 => 'resrequest\\api.rest.chart-container',
            34 => 'resrequest-api.rpc.chart-builder',
            35 => 'resrequest-api.rpc.filter-get-property-accomm',
            36 => 'resrequest-api.rpc.reservation-get-details',
            37 => 'resrequest-api.rpc.business-structure-get-properties',
            38 => 'resrequest-api.rpc.reservation-get-reservation',
            39 => 'resrequest-api.rpc.res-vega-get-access',
            40 => 'resrequest-api.rpc.res-vega-set-access',
            41 => 'resrequest-api.rpc.chart-get-access',
            42 => 'resrequest-api.rpc.res-vega-sign-up',
            43 => 'resrequest-api.rpc.res-vega-get-reports',
            44 => 'resrequest-api.rpc.public-get-reservation',
            45 => 'resrequest-api.rpc.public-save-guests',
            46 => 'resrequest-api.rpc.public-get-guests',
            47 => 'resrequest-api.rpc.public-check-in-guests',
            48 => 'resrequest-api.rpc.public-get-guest-settings',
            49 => 'resrequest-api.rpc.workflows-add-workflow',
            50 => 'resrequest-api.rpc.workflows-edit-workflow',
            51 => 'resrequest-api.rpc.workflows-delete-workflow',
            52 => 'resrequest-api.rpc.workflows-get-workflow',
            53 => 'resrequest-api.rpc.workflows-get-triggers',
            54 => 'resrequest-api.rpc.workflows-get-workflow-trigger',
            55 => 'resrequest-api.rpc.workflows-run-workflow',
            56 => 'resrequest-api.rpc.min-los-get-min-los',
            57 => 'resrequest-api.rpc.min-los-get-rule',
            58 => 'resrequest-api.rpc.min-los-delete-rule',
            59 => 'resrequest-api.rpc.min-los-edit-rule',
            60 => 'resrequest-api.rpc.min-los-add-rule',
            61 => 'resrequest-api.rpc.system-scripts',
            62 => 'resrequest-api.rpc.reminders-stop-reminders',
            63 => 'resrequest-api.rpc.system-scripts',
            64 => 'resrequest-api.rpc.system-command',
            65 => 'resrequest-api.rpc.imageset',
        ),
    ),
    'zf-rpc' => array(
        'Resrequest\\API\\V1\\Rpc\\Ping\\Controller' => array(
            'service_name' => 'Ping',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.ping',
        ),
        'Resrequest\\API\\V1\\Rpc\\RoomingGetRooms\\Controller' => array(
            'service_name' => 'RoomingGetRooms',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.rooming-get-rooms',
        ),
        'Resrequest\\API\\V1\\Rpc\\RoomingGetItems\\Controller' => array(
            'service_name' => 'RoomingGetItems',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.rooming-get-items',
        ),
        'Resrequest\\API\\V1\\Rpc\\RoomingSetItems\\Controller' => array(
            'service_name' => 'RoomingSetItems',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.rooming-set-items',
        ),
        'Resrequest\\API\\V1\\Rpc\\RoomingGetDefaultRate\\Controller' => array(
            'service_name' => 'RoomingGetDefaultRate',
            'http_methods' => array(
                0 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.rooming-get-default-rate',
        ),
        'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller' => array(
            'service_name' => 'AuthorisationGetAccess',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.authorisation-get-access',
        ),
        'Resrequest\\API\\V1\\Rpc\\Chart\\Controller' => array(
            'service_name' => 'Chart',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.chart',
        ),
        'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Controller' => array(
            'service_name' => 'OauthTokenRefresh',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.oauth-token-refresh',
        ),
        'Resrequest\\API\\V1\\Rpc\\RoomingGetStock\\Controller' => array(
            'service_name' => 'RoomingGetStock',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.rooming-get-stock',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller' => array(
            'service_name' => 'RemindersAddReminder',
            'http_methods' => array(
                0 => 'POST',
                1 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-add-reminder',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Controller' => array(
            'service_name' => 'RemindersEditReminder',
            'http_methods' => array(
                0 => 'POST',
                1 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-edit-reminder',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Controller' => array(
            'service_name' => 'RemindersDeleteReminder',
            'http_methods' => array(
                0 => 'POST',
                1 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-delete-reminder',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Controller' => array(
            'service_name' => 'RemindersGetReminder',
            'http_methods' => array(
                0 => 'POST',
                1 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-get-reminder',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Controller' => array(
            'service_name' => 'RemindersGetReferTo',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-get-refer-to',
        ),
        'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Controller' => array(
            'service_name' => 'ReminderGetUserEmail',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reminder-get-user-email',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller' => array(
            'service_name' => 'RemindersCountReminder',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-count-reminder',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller' => array(
            'service_name' => 'RemindersSendReminders',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-send-reminders',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Controller' => array(
            'service_name' => 'RemindersReport',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-report',
        ),
        'Resrequest\\API\\V1\\Rpc\\NotificationsGetUsers\\Controller' => array(
            'service_name' => 'NotificationsGetUsers',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.notifications-get-users',
        ),
        'Resrequest\\API\\V1\\Rpc\\NotificationGetReceipts\\Controller' => array(
            'service_name' => 'NotificationGetReceipts',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.notification-get-receipts',
        ),
        'Resrequest\\API\\V1\\Rpc\\NotificationAddNotification\\Controller' => array(
            'service_name' => 'NotificationAddNotification',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.notification-add-notification',
        ),
        'Resrequest\\API\\V1\\Rpc\\Info\\Controller' => array(
            'service_name' => 'Info',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.info',
        ),
        'Resrequest\\API\\V1\\Rpc\\RoomingGetRateAmount\\Controller' => array(
            'service_name' => 'RoomingGetRateAmount',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.rooming-get-rate-amount',
        ),
        'Resrequest\\API\\V1\\Rpc\\RoomingSetItem\\Controller' => array(
            'service_name' => 'RoomingSetItem',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.rooming-set-item',
        ),
        'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Controller' => array(
            'service_name' => 'ChartBuilder',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.chart-builder',
        ),
        'Resrequest\\API\\V1\\Rpc\\SystemInfo\\Controller' => array(
            'service_name' => 'SystemInfo',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.system-info',
        ),
        'Resrequest\\API\\V1\\Rpc\\SystemDiagnostics\\Controller' => array(
            'service_name' => 'SystemDiagnostics',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.system-diagnostics',
        ),
        'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Controller' => array(
            'service_name' => 'FinancialInterfaceGetOptions',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.financial-interface-get-options',
        ),
        'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Controller' => array(
            'service_name' => 'FinancialInterfaceSaveOptions',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.financial-interface-save-options',
        ),
        'Resrequest\\API\\V1\\Rpc\\FilterGetPropertyAccomm\\Controller' => array(
            'service_name' => 'FilterGetPropertyAccomm',
            'http_methods' => array(
                0 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.filter-get-property-accomm',
        ),
        'Resrequest\\API\\V1\\Rpc\\ReservationGetDetails\\Controller' => array(
            'service_name' => 'ReservationGetDetails',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reservation-get-details',
        ),
        'Resrequest\\API\\V1\\Rpc\\BusinessStructureGetProperties\\Controller' => array(
            'service_name' => 'BusinessStructureGetProperties',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.business-structure-get-properties',
        ),
        'Resrequest\\API\\V1\\Rpc\\ReservationGetReservation\\Controller' => array(
            'service_name' => 'ReservationGetReservation',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reservation-get-reservation',
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\Controller' => array(
            'service_name' => 'ResVegaGetAccess',
            'http_methods' => array(
                0 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.res-vega-get-access',
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller' => array(
            'service_name' => 'ResVegaSetAccess',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.res-vega-set-access',
        ),
        'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\Controller' => array(
            'service_name' => 'ChartGetAccess',
            'http_methods' => array(
                0 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.chart-get-access',
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller' => array(
            'service_name' => 'ResVegaSignUp',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.res-vega-sign-up',
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\Controller' => array(
            'service_name' => 'ResVegaGetReports',
            'http_methods' => array(
                0 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.res-vega-get-reports',
        ),
        'Resrequest\\API\\V1\\Rpc\\PublicGetReservation\\Controller' => array(
            'service_name' => 'PublicGetReservation',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.public-get-reservation',
        ),
        'Resrequest\\API\\V1\\Rpc\\PublicSaveGuests\\Controller' => array(
            'service_name' => 'PublicSaveGuests',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.public-save-guests',
        ),
        'Resrequest\\API\\V1\\Rpc\\PublicGetGuests\\Controller' => array(
            'service_name' => 'PublicGetGuests',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.public-get-guests',
        ),
        'Resrequest\\API\\V1\\Rpc\\PublicCheckInGuests\\Controller' => array(
            'service_name' => 'PublicCheckInGuests',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.public-check-in-guests',
        ),
        'Resrequest\\API\\V1\\Rpc\\PublicGetGuestSettings\\Controller' => array(
            'service_name' => 'PublicGetGuestSettings',
            'http_methods' => array(
                0 => 'GET',
            ),
            'route_name' => 'resrequest-api.rpc.public-get-guest-settings',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Controller' => array(
            'service_name' => 'WorkflowsAddWorkflow',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.workflows-add-workflow',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Controller' => array(
            'service_name' => 'WorkflowsEditWorkflow',
            'http_methods' => array(
                0 => 'PUT',
            ),
            'route_name' => 'resrequest-api.rpc.workflows-edit-workflow',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Controller' => array(
            'service_name' => 'WorkflowsDeleteWorkflow',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.workflows-delete-workflow',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Controller' => array(
            'service_name' => 'WorkflowsGetWorkflow',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.workflows-get-workflow',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Controller' => array(
            'service_name' => 'WorkflowsGetWorkflowTrigger',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.workflows-get-workflow-trigger',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Controller' => array(
            'service_name' => 'WorkflowsRunWorkflow',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.workflows-run-workflow',
        ),
        'Resrequest\\API\\V1\\Rpc\\SystemScripts\\Controller' => array(
            'service_name' => 'SystemScripts',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.system-scripts',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller' => array(
            'service_name' => 'MinLosGetMinLos',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.min-los-get-min-los',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller' => array(
            'service_name' => 'MinLosGetRule',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.min-los-get-rule',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller' => array(
            'service_name' => 'MinLosDeleteRule',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.min-los-delete-rule',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller' => array(
            'service_name' => 'MinLosEditRule',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.min-los-edit-rule',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\Controller' => array(
            'service_name' => 'MinLosAddRule',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.min-los-add-rule',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersStopReminders\\Controller' => array(
            'service_name' => 'RemindersStopReminders',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.reminders-stop-reminders',
        ),
        'Resrequest\\API\\V1\\Rpc\\SystemCommand\\Controller' => array(
            'service_name' => 'SystemCommand',
            'http_methods' => array(
                0 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.system-command',
        ),
        'Resrequest\\API\\V1\\Rpc\\Imageset\\Controller' => array(
            'service_name' => 'imageset',
            'http_methods' => array(
                0 => 'GET',
                1 => 'POST',
            ),
            'route_name' => 'resrequest-api.rpc.imageset',
        ),
    ),
    'zf-content-negotiation' => array(
        'controllers' => array(
            'Resrequest\\API\\V1\\Rpc\\Ping\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRooms\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetItems\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItems\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetDefaultRate\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\Chart\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\NotificationsGetUsers\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\NotificationGetReceipts\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\NotificationAddNotification\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetStock\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRateAmount\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItem\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\SystemInfo\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\SystemDiagnostics\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rest\\Chart\\Controller' => 'HalJson',
            'Resrequest\\API\\V1\\Rest\\ChartContainer\\Controller' => 'HalJson',
            'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\FilterGetPropertyAccomm\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ReservationGetDetails\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\BusinessStructureGetProperties\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ReservationGetReservation\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\PublicGetReservation\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\PublicSaveGuests\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuests\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\PublicCheckInGuests\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuestSettings\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\SystemScripts\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\RemindersStopReminders\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\SystemCommand\\Controller' => 'Json',
            'Resrequest\\API\\V1\\Rpc\\Imageset\\Controller' => 'Json',
        ),
        'accept_whitelist' => array(
            'Resrequest\\API\\V1\\Rpc\\Ping\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRooms\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetItems\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItems\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetDefaultRate\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\Chart\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetStock\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRateAmount\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItem\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\FilterGetPropertyAccomm\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ReservationGetDetails\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\BusinessStructureGetProperties\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ReservationGetReservation\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicGetReservation\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicSaveGuests\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuests\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicCheckInGuests\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuestSettings\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\SystemScripts\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersStopReminders\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\SystemCommand\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
            'Resrequest\\API\\V1\\Rpc\\Imageset\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
                2 => 'application/*+json',
            ),
        ),
        'content_type_whitelist' => array(
            'Resrequest\\API\\V1\\Rpc\\Ping\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRooms\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetItems\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItems\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetDefaultRate\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\Chart\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetStock\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingGetRateAmount\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RoomingSetItem\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rest\\Chart\\Controller' => array(
                0 => 'application/vnd.resrequest\\api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rest\\ChartContainer\\Controller' => array(
                0 => 'application/vnd.resrequest\\api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\SystemInfo\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\SystemDiagnostics\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\FilterGetPropertyAccomm\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ReservationGetDetails\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\BusinessStructureGetProperties\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ReservationGetReservation\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ChartGetAccess\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\ResVegaGetReports\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicGetReservation\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicSaveGuests\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuests\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicCheckInGuests\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\PublicGetGuestSettings\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\MinLosAddRule\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\SystemScripts\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\RemindersStopReminders\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\SystemCommand\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
            'Resrequest\\API\\V1\\Rpc\\Imageset\\Controller' => array(
                0 => 'application/vnd.resrequest-api.v1+json',
                1 => 'application/json',
            ),
        ),
    ),
    'zfr_cors' => array(
        'allowed_origins' => array(
            0 => '*',
        ),
        'allowed_methods' => array(
            0 => 'GET',
            1 => 'POST',
            2 => 'PUT',
            3 => 'PATCH',
            4 => 'DELETE',
            5 => 'OPTIONS',
        ),
        'allowed_headers' => array(
            0 => 'Authorization',
            1 => 'Content-Type',
        ),
        'exposed_headers' => array(
            0 => 'Auth-Error',
        ),
    ),
    'service_manager' => array(
        'factories' => array(
            'Resrequest\\API\\V1\\Rest\\Chart\\ChartResource' => 'Resrequest\\API\\V1\\Rest\\Chart\\ChartResourceFactory',
            'Resrequest\\API\\V1\\Rest\\ChartContainer\\ChartContainerResource' => 'Resrequest\\API\\V1\\Rest\\ChartContainer\\ChartContainerResourceFactory',
        ),
    ),
    'zf-rest' => array(
        'Resrequest\\API\\V1\\Rest\\Chart\\Controller' => array(
            'listener' => 'Resrequest\\API\\V1\\Rest\\Chart\\ChartResource',
            'route_name' => 'resrequest\\api.rest.chart',
            'route_identifier_name' => 'chart_id',
            'collection_name' => 'chart',
            'entity_http_methods' => array(
                0 => 'GET',
            ),
            'collection_http_methods' => array(),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => 'Resrequest\\API\\V1\\Rest\\Chart\\ChartEntity',
            'collection_class' => 'Resrequest\\API\\V1\\Rest\\Chart\\ChartCollection',
            'service_name' => 'chart',
        ),
        'Resrequest\\API\\V1\\Rest\\ChartContainer\\Controller' => array(
            'listener' => 'Resrequest\\API\\V1\\Rest\\ChartContainer\\ChartContainerResource',
            'route_name' => 'resrequest\\api.rest.chart-container',
            'route_identifier_name' => 'chart_container_id',
            'collection_name' => 'chart_container',
            'entity_http_methods' => array(
                0 => 'GET',
            ),
            'collection_http_methods' => array(),
            'collection_query_whitelist' => array(),
            'page_size' => 25,
            'page_size_param' => null,
            'entity_class' => 'Resrequest\\API\\V1\\Rest\\ChartContainer\\ChartContainerEntity',
            'collection_class' => 'Resrequest\\API\\V1\\Rest\\ChartContainer\\ChartContainerCollection',
            'service_name' => 'chartContainer',
        ),
    ),
    'zf-hal' => array(
        'metadata_map' => array(
            'Resrequest\\API\\V1\\Rest\\Chart\\ChartEntity' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'resrequest\\api.rest.chart',
                'route_identifier_name' => 'chart_id',
                'hydrator' => 'Zend\\Hydrator\\ClassMethods',
            ),
            'Resrequest\\API\\V1\\Rest\\Chart\\ChartCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'resrequest\\api.rest.chart',
                'route_identifier_name' => 'chart_id',
                'is_collection' => true,
            ),
            'Resrequest\\API\\V1\\Rest\\ChartContainer\\ChartContainerEntity' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'resrequest\\api.rest.chart-container',
                'route_identifier_name' => 'chart_container_id',
                'hydrator' => 'Zend\\Hydrator\\ClassMethods',
            ),
            'Resrequest\\API\\V1\\Rest\\ChartContainer\\ChartContainerCollection' => array(
                'entity_identifier_name' => 'id',
                'route_name' => 'resrequest\\api.rest.chart-container',
                'route_identifier_name' => 'chart_container_id',
                'is_collection' => true,
            ),
        ),
    ),
    'zf-content-validation' => array(
        'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\Chart\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\Chart\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Validator',
        ),
        'Resrequest\\API\\V1\\Rest\\Chart\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rest\\Chart\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Validator',
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Controller' => array(
            'input_filter' => 'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Validator',
        ),
    ),
    'input_filter_specs' => array(
        'Resrequest\\API\\V1\\Rpc\\AuthorisationGetAccess\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'accessRequest',
                'field_type' => '',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\Chart\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'contactId',
                'description' => 'Contact ID to return',
            ),
            1 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'chartRequest',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\OauthTokenRefresh\\Validator' => array(),
        'Resrequest\\API\\V1\\Rpc\\RemindersAddReminder\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reNote',
                'description' => 'Reminder Note',
            ),
            1 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reSendDate',
            ),
            2 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reSendDateTz',
            ),
            3 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReferToId',
            ),
            4 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'rePersonaId',
            ),
            5 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reIncludeMe',
            ),
            6 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reRepeatYn',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersEditReminder\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderId',
            ),
            1 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reNote',
            ),
            2 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reSendDate',
            ),
            3 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReferToId',
            ),
            4 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'rePersonaId',
            ),
            5 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reRepeatYn',
            ),
            6 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reIncludeMe',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersDeleteReminder\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderId',
                'description' => 'Reminder Id',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemidnersCountReminder\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 're_reservation_id',
                'description' => 'Reservation ID',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersGetReminder\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderId',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\ReminderGetUserEmail\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'query',
                'description' => 'Query word to be perform contacts look up',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersGetReferTo\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'query',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersCountReminder\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderReferenceId',
                'description' => 'The reference ID',
            ),
            1 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderReferenceTypeInd',
                'description' => 'Reference Type indicator',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersSendReminders\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'securityHash',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\RemindersReport\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderEnv',
                'description' => 'Reminder creation environment filter as array i.e: [\'WB\', \'PR\', \'RS\']',
            ),
            1 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderPersonaId',
                'description' => 'Reminder sent to persona_id',
            ),
            2 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderLinkToInd',
                'description' => 'Reminder (reservation or contacts) type filter as array i.e: [\'1\', \'2\']',
            ),
            3 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderLinkToId',
                'description' => 'Reminder reservation or contact ids filter as array i.e: [\'WB123\', \'RS456\']',
            ),
            4 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderStatusId',
                'description' => 'Reminder status filters as array i.e: [\'10\', \'20\', \'30\']',
            ),
            5 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderFromDate',
                'description' => 'Reminders created or send date to start search in Y-m-d format',
                'error_message' => 'Please provide report from date',
            ),
            6 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'reReminderToDate',
                'description' => 'Reminders created or send date to end search in Y-m-d format',
                'error_message' => 'Please provide report to date',
            ),
        ),
        'Resrequest\\API\\V1\\Rest\\Chart\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'var',
            ),
        ),
        'Resrequest\\API\\V1\\Rest\\ChartBuilder\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'chartConfig',
                'description' => 'Chart configuration to build chart from',
                'error_message' => 'Invalid chart configuration',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\ChartBuilder\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'chart',
                'description' => 'The configuration for the chart to be built.',
                'error_message' => 'No supplied chart configuration.',
            ),
            1 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'optionValues',
                'field_type' => '',
                'continue_if_empty' => false,
                'allow_empty' => false,
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\Notifications\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'securityHash',
                'description' => 'Required security code',
                'field_type' => 'String',
                'error_message' => 'Incorrect or no security code',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceGetOptions\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'invoicingUnit',
                'error_message' => 'Required parameter invoicingUnit is not present.',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\FinancialInterfaceSaveOptions\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'invoicingUnit',
            ),
            1 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'options',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaSetAccess\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(
                    0 => array(
                        'name' => 'Zend\\Validator\\Between',
                        'options' => array(
                            'min' => '0',
                            'max' => '2',
                        ),
                    ),
                ),
                'filters' => array(),
                'name' => 'access',
                'field_type' => '',
                'description' => 'The access level to set for the ResVega dashboards',
                'error_message' => 'Incorrect access level provided',
            ),
            1 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'securityHash',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\ResVegaSignUp\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'version',
                'description' => 'The ResVega version to request sign up for',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsAddWorkflow\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowName',
                'description' => 'Workflow name',
                'field_type' => '',
            ),
            1 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowDescription',
                'description' => 'Description of the workflow',
            ),
            2 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTypeInd',
                'description' => 'Type of the workflow',
            ),
            3 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowInactiveYn',
                'description' => 'Active / Inactive status of the workflow',
            ),
            4 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowScheduleDays',
                'description' => 'Number of days before or after even this workflow is scheduled for',
            ),
            5 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowBeforeAfterInd',
                'description' => 'Whether the workflow should be triggered before or after an event',
            ),
            6 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTriggerId',
                'description' => 'The ID of the event that triggers the workflow',
            ),
            7 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTime',
                'description' => 'The time the workflow should be triggered on',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsEditWorkflow\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowId',
                'description' => 'ID of the workflow to edit',
            ),
            1 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowName',
                'description' => '',
            ),
            2 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowDescription',
            ),
            3 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTypeInd',
            ),
            4 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowScheduleDays',
            ),
            5 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowBeforeAfterInd',
            ),
            6 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTriggerId',
            ),
            7 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTime',
            ),
            8 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTimeTz',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsDeleteWorkflow\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowId',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflow\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowId',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsGetWorkflowTrigger\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowTriggerId',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\WorkflowsRunWorkflow\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'awWorkflowId',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosGetMinLos\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'accommodationTypes',
                'description' => 'Accommodation types to retrieve MinLOS for',
                'field_type' => '',
            ),
            1 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'startDate',
                'description' => 'The start date range to get MinLOS for',
            ),
            2 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'endDate',
                'description' => 'The end date range to get MinLOS for',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosGetRule\\Validator' => array(
            0 => array(
                'required' => false,
                'validators' => array(),
                'filters' => array(),
                'name' => 'ids',
                'description' => 'Filter MinLOS rules by ID',
                'field_type' => 'array',
                'allow_empty' => true,
                'continue_if_empty' => true,
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosDeleteRule\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'id',
                'description' => 'ID of the MinLOS rule to delete',
            ),
        ),
        'Resrequest\\API\\V1\\Rpc\\MinLosEditRule\\Validator' => array(
            0 => array(
                'required' => true,
                'validators' => array(),
                'filters' => array(),
                'name' => 'id',
                'description' => 'ID of the MinLOS rule to edit',
            ),
        ),
    ),
);
