<?php
namespace Resrequest\API;
trait AuthenticatedUser
{
    public function getAuthenticatedUsername()
    {
        $identity = $this->getIdentity();

        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            // The username is indexed by user_id for some reason.
            return $identity->getAuthenticationIdentity()['user_id'];
        } else {
            return '';
        }
    }

    public function hasAuthenticatedUser()
    {
        return !!$this->getUsername();
    }
}
