<?php
namespace Resrequest\API\Authentication;

use DateTime;
use DateInterval;
use ZF\OAuth2\Adapter\PdoAdapter;
use Zend\Authentication\AuthenticationServiceInterface;

/**
 * Custom extension of PdoAdapter to validate against the pr_user table.
 */
class OAuth2Adapter extends PdoAdapter
{
	protected $em;
	protected $authService;
	protected $passwordService;

	public function __construct($connection, $config, $em, $authService, $passwordService)
	{
		$this->em = $em;
		$this->authService = $authService;
		$this->passwordService = $passwordService;
		$config = [
			'user_table' => 'pr_user'
		];
		return parent::__construct($connection, $config);
	}

	public function getUser($username)
	{
		$user = $this->authService->getUserByName($username);

		if (!$user) {
			return false;
		}

		// the default behavior is to use "username" as the user_id
		return array_merge(array(
			'user_id' => $username,
			'password' => $user['pr_user_password']
		), $user);
	}

	protected function checkPassword($user, $password)
	{
		$userDetails = $this->em->getConnection()->fetchAssoc("
			SELECT
				pr_user.pr_user_id,
				pr_user.pr_user_name,
				pr_user.pr_user_password,
				pr_user.pr_user_inactive_yn,
				pr_persona.pr_name_first,
				pr_persona.pr_name_last,
				pr_persona.pr_sys_code
			FROM
				pr_user
				INNER JOIN pr_persona ON pr_user.pr_user_id = pr_persona.pr_persona_ix
			WHERE
				pr_user.pr_user_name=?
				AND pr_user.pr_user_inactive_yn=0",
			[
				$user['user_id']
			]
		);
		if ($userDetails) {
			$this->authService->setupContext($userDetails, $password);
			if($this->passwordService->verify()) {
				$this->authService->clearExpiredTokens($userDetails['pr_user_name']);
				return true;
			}
		}
		return false;
	}
}
