<?php
namespace Resrequest\API\Authentication;

use ZF\OAuth2\Adapter\PdoAdapter;
use ZF\OAuth2\Controller\Exception;
use Resrequest\API\Authentication\OAuth2Adapter;
use Resrequest\Authentication\Service\Authenticate;
use Resrequest\Authentication\Service\Password;
use Zend\Authentication\AuthenticationService;

class OAuth2AdapterFactory
{
	public function __invoke($sm)
	{
		$config = $sm->get('config');
		if (empty($config['resrequest-oauth2']['db'])) {
			throw new Exception\RuntimeException(
				'The database configuration [\'resrequest-oauth2\'][\'db\'] for OAuth2 is missing'
			);
		}
		$username = isset($config['resrequest-oauth2']['db']['username']) ? $config['resrequest-oauth2']['db']['username'] : null;
		$password = isset($config['resrequest-oauth2']['db']['password']) ? $config['resrequest-oauth2']['db']['password'] : null;
		$options  = isset($config['resrequest-oauth2']['db']['options']) ? $config['resrequest-oauth2']['db']['options'] : [];
		$oauth2ServerConfig = [];
		if (isset($config['resrequest-oauth2']['storage_settings'])
			&& is_array($config['resrequest-oauth2']['storage_settings'])
		) {
			$oauth2ServerConfig = $config['resrequest-oauth2']['storage_settings'];
		}
		$entityManager = $sm->get('EnterpriseEntityManager');
		$authenticateService = $sm->get('Resrequest\Authentication\Service\Authenticate');
		$passwordService = $sm->get('Resrequest\Authentication\Service\Password');
		return new OAuth2Adapter(
			[
				'dsn'      => $config['resrequest-oauth2']['db']['dsn'],
				'username' => $username,
				'password' => $password,
				'options'  => $options,
			],
			$oauth2ServerConfig,
			$entityManager,
			$authenticateService,
			$passwordService
		);
	}

	/**
	 * Provided for backwards compatibility; proxies to __invoke().
	 *
	 * @param \Zend\ServiceManager\ServiceLocatorInterface $sm
	 * @return OAuth2Adapter
	 */
	public function createService($sm)
	{
		return $this($sm);
	}
}
