<?php

namespace Resrequest\API\Mailer;

use Zend\Mail;

class Mailer
{
	private $to;
	private $subject;
	private $body;

	public function __construct($to, $subject="", $body="")
	{
		if(is_string($to) || array_key_exists("email",$to)) {
			$to = array($to);
		}
		$this->to = $to;

		$this->subject = $subject;
		$this->body = $body;
	}

	public function send()
	{
		$mail = new Mail\Message();

		$mail->setFrom('support@resrequest.com',"ResRequest Plastic");
		$mail->setSubject($this->subject);
		$body = "Dear " . $this->to[0]['name'] . ",\n\n";
		$body .= $this->body;
		$body .= "\n\nFor any queries contact our support centre on support@resrequest.com.\n\nRegards,\nResRequest Support Team";
		$mail->setBody($body);

		foreach($this->to as $to) {
			if(is_string($to)) {
				$mail->addTo($to);
			} else {
				$mail->addTo($to['email'], $to['name']);
			}
		}

		$transport = new Mail\Transport\Sendmail();
		$transport->send($mail);
	}

	public function sendOtp($otpCode)
	{
		$this->subject = "Plastic OTP code";
		$this->body = "ResRequest Plastic Confirmation OTP: " . $otpCode . ".";
		return $this->send();
	}

	public function sendForgotten($url)
	{
		$this->subject = "Reset your Plastic password";
		$this->body = "Please click on the link to reset your password: $url";
		return $this->send();
	}

}
