<?php
namespace Resrequest\API;

use Zend\Mvc\MvcEvent;
use Zend\Uri\UriFactory;
use Zend\Console\Console;
use Zend\Mvc\ModuleRouteListener;
use Zend\ServiceManager\ServiceLocatorInterface;
use Zend\Mvc\ResponseSender\SendResponseEvent;
use ZF\MvcAuth\MvcAuthEvent;
use ZF\Apigility\Provider\ApigilityProviderInterface;
use Resrequest\API\Authorization\AuthorizationListener;
use Resrequest\API\Authentication\OAuth2AdapterFactory;

class Module implements ApigilityProviderInterface
{
	public function onBootstrap(MvcEvent $e)
	{
		$application = $e->getApplication();
		$sm = $application->getServiceManager();
		$eventManager = $application->getEventManager();
		$enterprise = $sm->get('Resrequest\Setup\Service\Enterprise');

		// Allow Postman to function
		UriFactory::registerScheme('chrome-extension', 'Zend\Uri\Uri');

		// Listen for authorization events
		$moduleRouteListener = new ModuleRouteListener();
		$moduleRouteListener->attach($eventManager);

        $moduleConfig = $this->getConfig();
        $request = $e->getRequest();
		// Wire in listener at priority >1 to ensure it runs before the
		// DefaultAuthorizationListener
		$eventManager->attach(
			MvcAuthEvent::EVENT_AUTHORIZATION,
			new AuthorizationListener($enterprise, $moduleConfig, $request),
			100
		);

		$eventManager->attach(SendResponseEvent::EVENT_SEND_RESPONSE,  function(SendResponseEvent $event) {
			$response = $event->getResponse();
			if ($response instanceof ApiProblemResponse) {
				$error = $response->getApiProblem()->toArray();
				// inspect $error array and log the information you want
			}
		});
	}

	public function getConfig()
	{
		if (Console::isConsole()) {
			return array();
		}
		
		$session_timeout = ini_get("session.gc_maxlifetime");
		if(!is_numeric($session_timeout) || $session_timeout < 300) {
			$session_timeout = 300;
		}

		$config = array(
			'resrequest-oauth2' => array(
				'db' => array(
					'dsn' => 'mysql:host=localhost;dbname='.$GLOBALS['dbName'],
					'username' => 'root',
				)
			),
			'zf-oauth2' => array(
				'access_lifetime' => $session_timeout,
				'options' => array(
					'refresh_token_lifetime' => $session_timeout,
					'always_issue_new_refresh_token' => false,
				),
				'storage_settings' => array(
					'user_table' => 'pr_user',
				),
			)
		);
		return array_merge(include __DIR__ . '/../../../config/module.config.php', $config);
	}

	public function getAutoloaderConfig()
	{
		return [
			'ZF\Apigility\Autoloader' => [
				'namespaces' => [
					__NAMESPACE__ => __DIR__
				],
			],
		];
	}

	public function getServiceConfig()
	{
		return array(
			'factories' => array(
				'Resrequest\API\Authentication\OAuth2Adapter' => function($sm) {
					$factory = new \Resrequest\API\Authentication\OAuth2AdapterFactory();
					return $factory($sm);
				},
			)
		);
	}
}
