<?php
namespace Resrequest\API;

use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;

trait PublicUser
{
	protected function publicUserContactLogin() {
        $params = $this->bodyParams();
        $db = $this->em->getConnection();

		if(!array_key_exists("reservation_id",$params) || !array_key_exists("email",$params)) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}
		$rv_reservation_id = $params['reservation_id'];
		$email = $params['email'];

        $reservation = $db->fetchAssoc("
            SELECT
				rv_reservation.rv_date_arrive
            FROM
                rv_reservation
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_corr_persona_id
            WHERE
                rv_reservation.rv_reservation_ix = ?
				AND pr_persona.pr_email = ?
				AND rv_reservation.rf_reservation_status_id IN (0,20,30)
		",[
			$rv_reservation_id,
			$email
		]);
		if($reservation === false) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}

		// Allow guest list updates on the arrival date, but not after
		if($reservation['rv_date_arrive'] < date("Y-m-d")) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Past bookings may not be updated.")
			);
		}

		$public_user_id = $db->fetchColumn("SELECT pr_persona.pr_persona_ix FROM pr_persona WHERE pr_sys_code = 7");
		if(empty($public_user_id)) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Unable to find public user")
			);
		}

		$this->auth->setupContext($this->auth->getUserById($public_user_id));
		return true;
	}

	protected function publicUserGuestLogin() {
        $params = $this->bodyParams();
        $db = $this->em->getConnection();

		if(!array_key_exists("reservation_id",$params) || !array_key_exists("email",$params)) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address")
			);
		}
		$rv_reservation_id = $params['reservation_id'];
		$email = $params['email'];

		$reservation = $db->fetchAssoc("
			SELECT DISTINCT
				rv_reservation.rv_date_arrive,
				rv_reservation.rv_date_depart
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
			WHERE
				rv_reservation_item.rv_reservation_id = ?
				AND pr_persona.pr_email = ?
				AND rv_reservation.rf_reservation_status_id IN (0,20,30)
		",[
			$rv_reservation_id,
			$email
		]);
		if($reservation === false) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address")
			);
		}

		// Allow checkin updates until the departure date
		if($reservation['rv_date_depart'] < date("Y-m-d")) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Past bookings may not be updated.")
			);
		}

		$limit7Days = date("Y-m-d", strtotime("+6 days"));
		if($reservation['rv_date_arrive'] > $limit7Days) {
            return new ApiProblemResponse(
                new ApiProblem(400, "This booking is not travelling yet. Come back later.")
			);
		}

		$public_user_id = $db->fetchColumn("SELECT pr_persona.pr_persona_ix FROM pr_persona WHERE pr_sys_code = 7");
		if(empty($public_user_id)) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Unable to find public user")
			);
		}

		$this->auth->setupContext($this->auth->getUserById($public_user_id));
		return true;
	}
}
