<?php
namespace Resrequest\API\V1\Rest\Chart;

class ChartEntity
{
    public $id;
    public $chart;
    public $data;
    public $peakMemory;
    public $debugData;

    protected $chartBuilder;

    public function __construct($id, $chartAndData)
    {
        $this->id = $id;
        $this->chart = $chartAndData['chart'];
        $this->data = $chartAndData['data'];
        $this->debugData = isset($chartAndData['debugData']) ? $chartAndData['debugData'] : [];
        $this->peakMemory = memory_get_peak_usage();
    }

    public function getId() {
        return $this->id;
    }

    public function getChart() {
        return $this->chart;
    }

    public function getData() {
        return $this->data;
    }

    public function getDebugData() {
        return $this->debugData;
    }

    public function getPeakMemory() {
        return $this->peakMemory;
    }
}
