<?php
namespace Resrequest\API\V1\Rest\ChartContainer;

class ChartContainerEntity
{
    public $id;
    public $name;
    public $description;
    public $config;
    public $charts;

    private $chartContainer;
    
    public function __construct($id, $chartContainer, $preloadChartData)
    {
        $this->id = $id;
        $this->chartContainer = $chartContainer;

        $container = $chartContainer->buildChartContainer($id, $preloadChartData);

        $this->name = $container['name'];
        $this->description = $container['description'];
        $this->config = $container['config'];
        $this->charts = $container['charts'];
    }

    public function getId() {
        return $this->id;
    }

    public function getName() {
        return $this->name;
    }

    public function getDescription() {
        return $this->description;
    }

    public function getConfig() {
        return $this->config;
    }

    public function getCharts() {
        return $this->charts;
    }
}
