<?php
namespace Resrequest\API\V1\Rpc\AuthorisationGetAccess;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/inc.setup.php');

class AuthorisationGetAccessController extends AbstractActionController
{
    private $authoriseService;

    public function __construct($authoriseService)
    {
        $this->authoriseService = $authoriseService;
    }

    public function authorisationGetAccessAction()
    {
        $params = $this->bodyParams();
        
        $accessRequest = $params['accessRequest'];
        $accessQueryResult = array();

        if (empty($_SESSION['userid'])) {
            return $this->error("Could not determine user ID", 500);
        }
        
        try {
            $accessQueryResult = $this->authoriseService->getAccess($accessRequest);
        } catch (\Exception $e) {
            return $this->error($e->getMessage(), 400);
        }

        return new JsonModel($accessQueryResult);
    }

    public function error($message, $code=403)
    {
        return new ApiProblemResponse(
             new ApiProblem($code, $message)
        );
    }
}
