<?php
namespace Resrequest\API\V1\Rpc\BusinessStructureGetProperties;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

define('BUSINESS_STRUCTURE_GET_PROPERTIES_SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))))); //Go back 5 directories
define('BUSINESS_STRUCTURE_GET_PROPERTIES_ROOT', BUSINESS_STRUCTURE_GET_PROPERTIES_SERVER. '/Application/src/Resrequest/legacy');
require_once(BUSINESS_STRUCTURE_GET_PROPERTIES_ROOT . '/inc.setup.php');

class BusinessStructureGetPropertiesController extends AbstractActionController
{
    protected $em;
    protected $authorise;
    protected $db;
    protected $http;
    protected $online_images_dir;
    protected $dbcode;

    public function __construct($em, $authorise)
    {
      $this->em = $em;
      $this->authorise = $authorise;
      $this->http = $GLOBALS['http'];
      $this->online_images_dir = $GLOBALS['online_images_dir'];
      $this->dbcode = $GLOBALS['dbcode'];
      $this->principalid = $GLOBALS['principal_id'];
      $this->db = $this->em->getConnection();
    }

    public function businessStructureGetPropertiesAction()
    {
      $params = $this->bodyParams();

      $user = $this->checkUser();

      // Property parameters
      $prBusinessId = $params['prBusinessId'] ?? false;
      $prNameLast = isset($params['prNameLast']) ? str_replace("*", "%", $params['prNameLast']) : false;
      $prBusMemoCalYn = $params['prBusMemoCalYn'] ?? false;
      $prBusMemoInfoYn = $params['prBusMemoInfoYn'] ?? false;
      $prBusinessGpsCoordsYn = $params['prBusinessGpsCoordsYn'] ?? false;
      $prBusinessSocialLinksYn = $params['prBusinessSocialLinksYn'] ?? false;
      $prBusinessImagesYn = $params['prBusinessImagesYn'] ?? false;
      $prWebAddrYn = $params['prWebAddrYn'] ?? false;

      $propertyFields = [
        'ac_accomm_type.prBusinessId',
        'business_persona.prNameLast AS businessName',
        'business_persona.prEmail',
        'PrPhone.prPhoneNumber'
      ];
      if($prBusMemoCalYn === true) {
        $propertyFields[] = "PrBusiness.prBusMemoCal";
      }
      if($prBusMemoInfoYn === true) {
        $propertyFields[] = "PrBusiness.prBusMemoInfo";
      }
      if($prWebAddrYn === true) {
        $propertyFields[] = "business_persona.prWebAddr";
      }

      // Accommodation parameters
      $acAccommTypeIx = $params['acAccommTypeIx'] ?? false;
      $acAccommDesc = isset($params['acAccommDesc']) ? str_replace("*", "%", $params['acAccommDesc']) : false;
      $acAccommNoteYn = $params['acAccommNoteYn'] ?? false;
      $acAccommMaxCapacityYn = $params['acAccommMaxCapacityYn'] ?? false;
      $acAccommMaxAdultsYn = $params['acAccommMaxAdultsYn'] ?? false;
      $acAccommMaxChildAgeYn = $params['acAccommMaxChildAgeYn'] ?? false;
      $acAccommCapacityYn = $params['acAccommCapacityYn'] ?? false;
      $acAccommImagesYn = $params['acAccommImagesYn'] ?? false;

      $accommodationFields = [
        'ac_accomm_type.acAccommTypeIx',
        'ac_accomm_type.acAccommDesc',
        'ac_accomm_type.acAccommNoOfUnits',
        'ac_accomm_type.acAccommMaxCapacity',
        'ac_accomm_type.acAccommMaxAdults',
        'ac_accomm_type.acAccommMaxChildAge'
      ];
      if($acAccommNoteYn === true) {
        $accommodationFields[] = "ac_accomm_type.acAccommNote AS ac_accomm_note";
      }
      if($acAccommMaxCapacityYn === true) {
        $accommodationFields[] = "ac_accomm_type.acAccommMaxCapacity AS ac_accomm_max_capacity";
      }
      if($acAccommMaxAdultsYn === true) {
        $accommodationFields[] = "ac_accomm_type.acAccommMaxAdults AS ac_accomm_max_adults";
      }
      if($acAccommMaxChildAgeYn === true) {
        $accommodationFields[] = "ac_accomm_type.acAccommMaxChildAge AS ac_accomm_max_child_age";
      }
      if($acAccommCapacityYn === true) {
        $accommodationFields[] = "ac_accomm_type.acAccommCapacity AS ac_accomm_capacity";
      }

      $propertyQuery = $this->em->createQueryBuilder();
      $propertyQueryParameters = [
        'sc_group_id' => $user['scGroupId'],
        'prNameLast' => ($prNameLast ?? "%")
      ];
      $propertyQuery
        ->select($propertyFields)
        ->distinct("ac_accomm_type.prBusinessId")
        ->from('Resrequest\DB\Enterprise\Entity\ScAccomm', 'sc_accomm')
        ->innerJoin('Resrequest\DB\Enterprise\Entity\AcAccommType', 'ac_accomm_type', 'with', 'ac_accomm_type.acAccommTypeIx = sc_accomm.acAccommTypeId')
        ->innerJoin('Resrequest\DB\Enterprise\Entity\PrBusiness', 'PrBusiness', 'with', 'PrBusiness.prBusinessId = ac_accomm_type.prBusinessId')
        ->innerJoin('Resrequest\DB\Enterprise\Entity\PrPersona', 'business_persona', 'with', 'business_persona.prPersonaIx = PrBusiness.prBusinessId')
        ->leftJoin('Resrequest\DB\Enterprise\Entity\PrPhone', 'PrPhone', 'with', 'PrPhone.prPersonaId = PrBusiness.prBusinessId')
        ->where('sc_accomm.scGroupId = :sc_group_id')
        ->andWhere('ac_accomm_type.acAccommTypeInactiveYn = 0')
        ->andWhere('PrBusiness.prBusInactiveYn = 0')
        ->andWhere('business_persona.prNameLast LIKE :prNameLast');
      if ($prBusinessId !== false && is_array($prBusinessId)) {
        $propertyQuery->andWhere('PrBusiness.prBusinessId IN (:prBusinessId)');
        $propertyQueryParameters['prBusinessId'] = $prBusinessId;
      }
      if ($acAccommTypeIx !== false && is_array($acAccommTypeIx)) {
        $propertyQuery->andWhere('ac_accomm_type.acAccommTypeIx IN (:acAccommTypeIx)');
        $propertyQueryParameters['acAccommTypeIx'] = $acAccommTypeIx;
      }
      $propertyList = $propertyQuery
        ->setParameters($propertyQueryParameters)
        ->getQuery()
        ->getResult();

      $tree = $this->getPropertyTree();
      $propertiesSorted = [];
      foreach ($tree as $branch) {
        foreach ($propertyList as $property) {
          if ($property['prBusinessId'] == $branch) {
            $propertiesSorted[] = $property;
          }
        }
      }

      $properties = [];
      foreach ($propertiesSorted as $property) {
        $item = [
          'prBusinessId' => $property['prBusinessId'], 
          'prNameLast' => $property['businessName'],
          'prEmail' => $property['prEmail'],
          'prPhoneNumber' => $property['prPhoneNumber']
        ];
        if($prBusMemoCalYn === true) {
          $item['prBusMemoCal'] = $property['prBusMemoCal'];
        }
        if($prBusMemoInfoYn === true) {
          $item['prBusMemoInfo'] = $property['prBusMemoInfo'];
        }
        if($prWebAddrYn === true) {
          $item['prWebAddr'] = $property['prWebAddr'];
        }
        if ($prBusinessGpsCoordsYn === true) {
          $gpsQuery = $this->em->createQueryBuilder();
          $gpsDetails = $gpsQuery
            ->select(
              [ 
                "PrBusiness.prBusPropLatitude",
                "PrBusiness.prBusPropLongitude"
              ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\PrBusiness', 'PrBusiness')
            ->where('PrBusiness.prBusinessId = :businessId')
            ->orderBy('PrBusiness.prBusinessSequence')
            ->setParameters( [ 'businessId' => $property['prBusinessId'] ] )
            ->setMaxResults(1)
            ->getQuery()
            ->getOneOrNullResult();
          $item['prBusinessGpsCoords'] = [
            'prBusPropLatitude' => $gpsDetails['prBusPropLatitude'],
            'prBusPropLongitude'=>$gpsDetails['prBusPropLongitude']
          ];
        }
        if ($prBusinessSocialLinksYn === true) {
          $socialQuery = $this->em->createQueryBuilder();
          $socialDetails = $socialQuery
            ->select(
              [
                'pr_social.prSocialLabel',
                'pr_bus_social.prBusSocialData'
              ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\PrBusSocial', 'pr_bus_social')
            ->innerJoin('Resrequest\DB\Enterprise\Entity\PrSocial', 'pr_social', 'with', 'pr_social.prSocialIx = pr_bus_social.prSocialId')
            ->where('pr_bus_social.prBusinessId = :businessId')
            ->orderBy('pr_social.prSocialSortSeq', 'ASC')
            ->setParameters( [ 'businessId' => $property['prBusinessId'] ] )
            ->getQuery()
            ->getResult();
          $item['prBusinessSocialLinks'] = $socialDetails ?? [];
        }

        if ($prBusinessImagesYn === true) {
          $imagesQuery = $this->em->createQueryBuilder();
          $images = $imagesQuery
            ->select(
              [
                'pr_bus_image.prBusImageDesc AS pr_bus_image_desc',
                'pr_bus_image.prBusImageFilename AS pr_bus_image_filename'
              ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\PrBusImage', 'pr_bus_image')
            ->where('pr_bus_image.prBusinessId = :businessId')
            ->orderBy('pr_bus_image.prBusImageDesc', 'ASC')
            ->setParameters( [ 'businessId' => $property['prBusinessId'] ] )
            ->getQuery()
            ->getResult();
          $item['prBusinessImages'] = [];
          foreach ($images as $image) {
            $item['prBusinessImages'][] = [
              'prBusImageDesc' => $image['pr_bus_image_desc'],
              'prBusImageFilename' => $this->http.$this->online_images_dir.'/'.$this->principalid.'/business_structure/'.$property['prBusinessId'].'/'.$image['pr_bus_image_filename']
            ];
          }
        }

        if($prWebAddrYn === true) {
          $item['prWebAddr'] = $property['prWebAddr'];
        }

        $accommodationsQuery = $this->em->createQueryBuilder();
        $accommodationsQueryParameters = [
          'sc_group_id' => $user['scGroupId'],
          'businessId' => $property['prBusinessId'],
          'acAccommDesc' => ($acAccommDesc ?? "%")
        ];
        $accommodationsQuery
          ->select($accommodationFields)
          ->from('Resrequest\DB\Enterprise\Entity\ScAccomm', 'sc_accomm')
          ->innerJoin('Resrequest\DB\Enterprise\Entity\AcAccommType', 'ac_accomm_type', 'with', 'ac_accomm_type.acAccommTypeIx = sc_accomm.acAccommTypeId')
          ->where('sc_accomm.scGroupId = :sc_group_id')
          ->andWhere('ac_accomm_type.prBusinessId = :businessId')
          ->andWhere('ac_accomm_type.acAccommTypeInactiveYn = 0')
          ->andWhere('ac_accomm_type.acAccommDesc LIKE :acAccommDesc');
        if ($acAccommTypeIx !== false && is_array($acAccommTypeIx)) {
          $accommodationsQuery->andWhere('ac_accomm_type.acAccommTypeIx IN (:acAccommTypeIx)');
          $accommodationsQueryParameters['acAccommTypeIx'] = $acAccommTypeIx;
        }

        $accommodations = $accommodationsQuery
          ->setParameters($accommodationsQueryParameters)
          ->getQuery()
          ->getResult();
        $item['acAccommType'] = [];
        foreach ($accommodations as $accommodation) {
          $accommodationType = [];
          $accommodationType['acAccommTypeIx'] = $accommodation['acAccommTypeIx'];
          $accommodationType['acAccommDesc'] = $accommodation['acAccommDesc'];
          $unitsQuery = $this->em->createQueryBuilder();
          $units = $unitsQuery
            ->select("COUNT(AcAccommRoom.acAccommRoomIx)")
            ->from('Resrequest\DB\Enterprise\Entity\AcAccommRoom', 'AcAccommRoom')
            ->where('AcAccommRoom.acAccommTypeId = :accommodationId')
            ->andWhere('AcAccommRoom.acAccommRoomInactiveYn = 0')
            ->setParameters([
            'accommodationId' => $accommodation['acAccommTypeIx'],
            ])
            ->getQuery()
            ->getSingleScalarResult();
          $accommodationType['acAccommNoOfUnits'] = $units;

          if($acAccommNoteYn === true) {
            $accommodationType['acAccommNote'] = $accommodation['ac_accomm_note'];
          }
          if($acAccommMaxCapacityYn === true) {
            $accommodationType['acAccommMaxCapacity'] = $accommodation['ac_accomm_max_capacity'];
          }
          if($acAccommMaxAdultsYn === true) {
            $accommodationType['acAccommMaxAdults'] = $accommodation['ac_accomm_max_adults'];
          }
          if($acAccommMaxChildAgeYn === true) {
            $accommodationType['acAccommMaxChildAge'] = $accommodation['ac_accomm_max_child_age'];
          }
          if($acAccommCapacityYn === true) {
            $accommodationType['acAccommCapacity'] = $accommodation['ac_accomm_capacity'];
          }
          if($acAccommImagesYn === true) {
            $accommodationImagesQuery = $this->em->createQueryBuilder();
            $accommodationImages = $accommodationImagesQuery
              ->select(
                [
                  'AcAccommImage.acAccommImageDesc',
                  'AcAccommImage.acAccommImageFilename'
                ]
              )
              ->from('Resrequest\DB\Enterprise\Entity\AcAccommImage', 'AcAccommImage')
              ->where('AcAccommImage.acAccommTypeId = :accommodationId')
              ->orderBy('AcAccommImage.acAccommImageDesc', 'ASC')
              ->setParameters( [ 'accommodationId' => $accommodation['acAccommTypeIx'] ] )
              ->getQuery()
              ->getResult();
            $images = [];
            foreach ($accommodationImages as $accommodationImage) {
              $images[] = [
                'acAccommImageDesc' => $accommodationImage['acAccommImageDesc'],
                'acAccommImageFilename' => $this->http.$this->online_images_dir.'/'.$this->principalid.'/business_structure/'.$property['prBusinessId'].'/'.$accommodation['acAccommTypeIx'].'/'.$accommodationImage['acAccommImageFilename']
              ];
            }
            $accommodationType['acAccommImages'] = $images; 
          }
          $item['acAccommType'][] = $accommodationType;
        }

        $properties[] = $item;
      }

      return new JsonModel($properties);
    }

    private function getPropertyTree(string $propertyId = "0", array &$propertyTree = [])
    {
      $parentQuery = $this->em->createQueryBuilder();
      $parents = $parentQuery
        ->select("PrBusiness.prBusinessId")
        ->distinct("PrBusiness.prBusinessId")
        ->from('Resrequest\DB\Enterprise\Entity\PrBusiness', 'PrBusiness')
        ->where('PrBusiness.prBusinessParent = :propertyId')
        ->orderBy('PrBusiness.prBusinessSequence')
        ->setParameters( [ 'propertyId' => $propertyId ] )
        ->getQuery()
        ->getResult();
      foreach($parents as $parent) {
        $propertyTree[] = $parent['prBusinessId'];
        $this->getPropertyTree($parent['prBusinessId'], $propertyTree);
      }

      return $propertyTree;
    }

    private function checkUser()
    {
      $username = false;
      $identity = $this->getIdentity();
      if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
          $username = $identity->getAuthenticationIdentity()['user_id'];
      }

      $userQuery = $this->em->createQueryBuilder();
      $user = $userQuery
        ->select(
          [
            'pr_user.prUserId',
            'sc_user.scGroupId'
          ]
        )
        ->from('Resrequest\DB\Enterprise\Entity\ScUser', 'sc_user')
        ->innerJoin('Resrequest\DB\Enterprise\Entity\PrUser', 'pr_user', 'with', 'pr_user.prUserId = sc_user.prUserId')
        ->where('pr_user.prUserName = :pr_user_name')
        ->setParameters(
          [ 'pr_user_name' => $username ]
        )
        ->setMaxResults(1)
        ->getQuery()
        ->getOneOrNullResult();
      if($username === false || $user === null) {
          return new ApiProblemResponse(
              new ApiProblem(403, "Unable to find user")
          );
      }

      return $user;
    }
}
