<?php
namespace Resrequest\API\V1\Rpc\Chart;

class ChartControllerFactory
{
    public function __invoke($controllers)
    {
        $sm = $controllers->getServiceLocator();
        $em = $sm->get('EnterpriseEntityManager');
        $enterprise = $sm->get('Resrequest\Setup\Service\Enterprise');
        $chartBuilder = $sm->get('Resrequest\Application\Chart\ChartBuilder');
        $authentication = $sm->get('Resrequest\Authentication\Service\Authenticate');
        $authorisation = $sm->get('Resrequest\Authorisation\Service\AuthoriseService');

        return new ChartController($em, $enterprise, $chartBuilder, $authentication, $authorisation);
    }
}
