<?php

namespace Resrequest\API\V1\Rpc\ChartBuilder;

use Resrequest\Application\Chart\ChartBuilder;
use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

class ChartBuilderController extends AbstractActionController
{
    /**
     * The chart builder.
     *
     * @var ChartBuilder
     */
    public $chartBuilder;
    protected $auth;

    public function __construct($chartBuilder, $auth)
    {
        $this->chartBuilder = $chartBuilder;
        $this->auth = $auth;
    }

    public function chartBuilderAction()
    {
        $username = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if ($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $this->auth->setupContext($this->auth->getUserByName($username));

        $params = $this->bodyParams();
        $chartConfig = $params['chart'];

        if (empty($params['optionValues'])) {
            $optionValues = [];
        } else {
            $optionValues = $params['optionValues'];
        }

        return new JsonModel($this->chartBuilder->getChartAndData($chartConfig, $optionValues));
    }
}
