<?php
namespace Resrequest\API\V1\Rpc\ChartGetAccess;

use Resrequest\Application\Chart\ChartBuilder;
use Resrequest\Application\Chart\ChartContainer;
use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

class ChartGetAccessController extends AbstractActionController
{
    private $auth;
    private $chartBuilder;
    private $chartContainerService;

    public function __construct(ChartBuilder $chartBuilder, ChartContainer $chartContainerService, $auth)
    {
        $this->chartBuilder = $chartBuilder;
        $this->chartContainerService = $chartContainerService;
        $this->auth = $auth;
    }

    public function chartGetAccessAction()
    {
        $username = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if ($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $this->auth->setupContext($this->auth->getUserByName($username));

        $containers = [];
        $containerSummaries = $this->chartContainerService->getContainerSummaries();
        foreach($containerSummaries as $chartContainer) {
            $hidden = $this->chartContainerService->isChartContainerHidden($chartContainer['id']);
            $disabled = $this->chartContainerService->isChartContainerDisabled($chartContainer['id']);
            $allowed = $this->chartContainerService->isChartContainerAllowed($chartContainer['id'], false, true);

            $containers[] = [
                'id' => $chartContainer['id'],
                'hidden' => $hidden,
                'disabled' => $disabled,
                'allowed' => $allowed
            ];
        }

        $charts = [];
        $chartSummaries = $this->chartBuilder->getChartSummaries();

        foreach ($chartSummaries as $chart) {
            $allowed = $this->chartBuilder->canAccessChart($chart['id']);

            $charts[] = [
                'id' => $chart['id'],
                'allowed' => $allowed
            ];
        }

        return new JsonModel([
            'charts' => $charts,
            'containers' => $containers
        ]);
    }
}
