<?php
namespace Resrequest\API\V1\Rpc\FilterGetPropertyAccomm;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblem;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ContentNegotiation\JsonModel;

class FilterGetPropertyAccommController extends AbstractActionController
{
    protected $entityManager;

    public function __construct($entityManager)
    {
        $this->entityManager = $entityManager;
    }

    public function filterGetPropertyAccommAction()
    {
        $groupId = $this->getUserGroup();

        if (!$groupId) {
            return $this->error('User not valid', 403);
        }

        $properties = $this->getProperties($groupId);

        foreach ($properties as &$property) {
            $property['accommodations'] = $this->getAccommodations(
                $property['id'],
                $groupId
            );
        }

        return new JsonModel($properties);
    }

    private function getUserGroup()
    {
        $identity = $this->getIdentity();

        if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        } else {
            return null;
        }

        $userQuery = $this->entityManager->createQueryBuilder();
        $groupId = $userQuery
            ->select('scUserTable.scGroupId AS groupId')
            ->from('Resrequest\DB\Enterprise\Entity\PrUser', 'prUserTable')
            ->innerJoin(
                'Resrequest\DB\Enterprise\Entity\ScUser',
                'scUserTable',
                'with',
                'scUserTable.prUserId = prUserTable.prUserId'
            )
            ->where('prUserTable.prUserName = :username')
            ->setParameter('username', $username)
            ->getQuery()
            ->getSingleScalarResult();

        return $groupId;
    }

    private function error($message, $code = 403)
    {
        return new ApiProblemResponse(
            new ApiProblem($code, $message)
        );
    }

    private function getProperties($groupId)
    {
        $propertyQuery = $this->entityManager->createQueryBuilder();
        $properties = $propertyQuery
            ->select(
                [
                    'acAccommTypeTable.prBusinessId AS id',
                    'prPersonaTable.prNameLast AS name',
                    'prBusinessTable.prBusNameShort AS shortName',
                    'prBusinessTable.prBusInactiveYn AS inactive'
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\ScAccomm', 'scAccommTable')
            ->innerJoin(
                'Resrequest\DB\Enterprise\Entity\AcAccommType',
                'acAccommTypeTable',
                'with',
                'acAccommTypeTable.acAccommTypeIx = scAccommTable.acAccommTypeId'
            )
            ->innerJoin(
                'Resrequest\DB\Enterprise\Entity\PrBusiness',
                'prBusinessTable',
                'with',
                'prBusinessTable.prBusinessId = acAccommTypeTable.prBusinessId'
            )
            ->innerJoin(
                'Resrequest\DB\Enterprise\Entity\PrPersona',
                'prPersonaTable',
                'with',
                'prPersonaTable.prPersonaIx = prBusinessTable.prBusinessId'
            )
            ->where('scAccommTable.scGroupId = :groupId')
            ->orderBy('prBusinessTable.prBusinessSequence')
            ->setParameter('groupId', $groupId)
            ->distinct()
            ->getQuery()
            ->getResult();

        return $properties;
    }

    private function getAccommodations($propertyId, $groupId)
    {
        $accommodationQuery = $this->entityManager->createQueryBuilder();
        $accommodations = $accommodationQuery
            ->select(
                'acAccommTypeTable.acAccommTypeIx AS id',
                'acAccommTypeTable.acAccommDesc AS name',
                'acAccommTypeTable.acAccommTypeInactiveYn AS inactive'
            )
            ->from('Resrequest\DB\Enterprise\Entity\ScAccomm', 'scAccommTable')
            ->innerJoin(
                'Resrequest\DB\Enterprise\Entity\AcAccommType',
                'acAccommTypeTable',
                'with',
                'acAccommTypeTable.acAccommTypeIx = scAccommTable.acAccommTypeId'
            )
            ->where('scAccommTable.scGroupId = :groupId')
            ->andWhere('acAccommTypeTable.prBusinessId = :propertyId')
            ->orderBy('acAccommTypeTable.acAccommSequence')
            ->setParameters(
                [
                    'groupId' => $groupId,
                    'propertyId' => $propertyId
                ]
            )
            ->distinct()
            ->getQuery()
            ->getResult();

        return $accommodations;
    }
}
