<?php
namespace Resrequest\API\V1\Rpc\FinancialInterfaceGetOptions;

use Zend\Mvc\Controller\AbstractActionController;
use Doctrine\ORM\EntityManager;
use ZF\ApiProblem\ApiProblem;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ContentNegotiation\JsonModel;
use Resrequest\Application\Financial\System\FinancialOptions;

class FinancialInterfaceGetOptionsController extends AbstractActionController
{
    /**
     * For working with financial options.
     *
     * @var FinancialOptions
     */
    private $financialOptions;

    public function __construct(EntityManager $entityManager)
    {
        $this->financialOptions = new FinancialOptions($entityManager);
    }

    public function financialInterfaceGetOptionsAction()
    {
        $params = $this->bodyParams();
        $invoicingUnit = $params['invoicingUnit'];

        if (!$this->financialOptions->isValidInvoicingUnit($invoicingUnit)) {
            return $this->error('The invoicing unit is invalid or does not have a financial system set', 400);
        }

        return new JsonModel([
            'options' => $this->financialOptions->optionsForInvoicingUnit($invoicingUnit)
        ]);
    }

    public function error($message, $code = 403)
    {
        return new ApiProblemResponse(
            new ApiProblem($code, $message)
        );
    }
}
