<?php
namespace Resrequest\API\V1\Rpc\FinancialInterfaceSaveOptions;

use Zend\Mvc\Controller\AbstractActionController;
use Doctrine\ORM\EntityManager;
use ZF\ApiProblem\ApiProblem;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ContentNegotiation\JsonModel;
use Resrequest\Application\Financial\System\FinancialOptions;

class FinancialInterfaceSaveOptionsController extends AbstractActionController
{
    /**
     * For working with financial options.
     *
     * @var FinancialOptions
     */
    private $financialOptions;

    public function __construct(EntityManager $entityManager)
    {
        $this->financialOptions = new FinancialOptions($entityManager);
    }

    public function financialInterfaceSaveOptionsAction()
    {
        $params = $this->bodyParams();
        $invoicingUnit = $params['invoicingUnit'];

        if (!$this->financialOptions->isValidInvoicingUnit($invoicingUnit)) {
            return $this->error('The invoicing unit is invalid or does not have a financial system set.', 400);
        }

        $options = [];

        if (array_key_exists('options', $params) && is_array($params['options'])) {
            $options = $params['options'];
        }

        if (!$this->financialOptions->validOptions($invoicingUnit, $options)) {
            return $this->error('One or more of the options provided are not valid for the set financial system.', 400);
        }

        $this->financialOptions->saveOptions($invoicingUnit, $options);

        return new JsonModel([
            'message' => 'The financial options have been saved.'
        ]);
    }

    public function error($message, $code = 403)
    {
        return new ApiProblemResponse(
            new ApiProblem($code, $message)
        );
    }
}
