<?php
namespace Resrequest\API\V1\Rpc\Imageset;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

class ImagesetController extends AbstractActionController
{
    protected $em, $password;
    private $params;

    public function __construct($em, $enterprise, $authentication, $authorisation)
    {
        $this->em = $em;
        $this->enterprise = $enterprise;
        $this->config = $enterprise->config;
        $this->authenticateService = $authentication;
        $this->authorisation = $authorisation;
    }

    public function imagesetAction()
    {
        $this->params = $this->bodyParams();

        if (!isset($this->params['method']) || empty($this->params['method'])) {
            return new ViewModel(['data' => '', 'error' => 'No method specified', 'code' => 409]);
        }

        switch ($this->params['method']) {
            case "getPrincipalInfo":
                return $this->getPrincipalInfo();
                break;
            case "login":
                return $this->login();
                break;
            case "emailSend":
                return $this->emailSend();
                break;
        }
    }

    private function getPrincipalInfo()
    {
        $query = $this->em->createQueryBuilder();
        $principal = $query
            ->select(
                [
                    "TRIM(CONCAT(prPersona.prNameFirst, ' ', prPersona.prNameLast)) AS name",
                    "prPersona.prEmail AS email"
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfDefault', 'rfDefault')
            ->innerJoin('Resrequest\DB\Enterprise\Entity\PrPersona', 'prPersona', 'with', 'prPersona.prPersonaIx = rfDefault.rfPrincipalId')
            ->getQuery()
            ->getResult();
        $principalName = $principal[0]['name'];
        $principalEmail = $principal[0]['email'];

        $query = $this->em->createQueryBuilder();
        $resOffice = $query
            ->select(
                [
                    "TRIM(CONCAT(prPersona.prNameFirst, ' ', prPersona.prNameLast)) AS name",
                    "prPersona.prEmail AS email"
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfDefault', 'rfDefault')
            ->innerJoin('Resrequest\DB\Enterprise\Entity\PrPersona', 'prPersona', 'with', 'prPersona.prPersonaIx = rfDefault.rfResOfficeId')
            ->getQuery()
            ->getResult();
        $resOfficeName = $resOffice[0]['name'];
        $resOfficeEmail = $resOffice[0]['email'];

        $db = $this->em->getConnection();
        $bookingInfo = $db->fetchColumn("
            SELECT
                rf_booking_info
            FROM
                rf_custom
            WHERE
                rf_custom_id = ?
        ",[
            1
        ]);

        $resOfficeID = $db->fetchColumn("
            SELECT
                rf_res_office_id
            FROM
                rf_default
        ");
        
        $resOfficeFax = $db->fetchColumn("
            SELECT
                pr_phone.pr_phone_number
            FROM
                pr_phone, 
                rf_phone_type 
            WHERE 
                pr_phone.pr_persona_id = ?
            AND 
                pr_phone.rf_phone_type_id = rf_phone_type.rf_phone_type_ix 
            AND 
                rf_phone_type.rf_phone_type_sys_code = '1' 
        ",[
            $resOfficeID
        ]);
        
        $resOfficeTel = $db->fetchColumn("
            SELECT 
                pr_phone.pr_phone_number 
            FROM 
                pr_phone 
            WHERE 
                pr_phone.pr_persona_id = ?
            AND 
                pr_phone.pr_default_yn = '1'
        ",[
            $resOfficeID
        ]);
        
        return new ViewModel([
            'shortName' => $this->config['shortName'],
            'principalId' => $this->config['principalId'],
            'principalName' => $principalName,
            'principalEmail' => $principalEmail,
            'databaseName' => $this->config['databaseName'],
            'environment' => $this->config['environment'],
            'codeVersion' => $this->config['codeVersion'],
            'archive' => $this->config['archive'],
            'onlineImagesDir' => $this->config['images']['online_images_dir'],
            'imagesDirOnDisk' => $this->config['images']['images_dir_on_disk'],
            'imagesDir' => $this->config['images']['images_dir'],
            'bookingInfo' => $bookingInfo,
            'resOfficeTel' => $resOfficeTel != '' && $resOfficeTel != '0' ? $resOfficeTel : '',
            'resOfficeFax' => $resOfficeFax != '' && $resOfficeFax != '0' ? $resOfficeFax : '',
            'resOfficeName' => $resOfficeName,
            'resOfficeEmail' => $resOfficeEmail
        ]);
    }

    private function login()
    {
        if (!empty($this->params['username']) && !empty($this->params['password'])) {
            $authenticated = $this->authenticateService->login($this->params['username'], $this->params['password']);
            $this->enterprise->onLogin();
            $sc_group_id = $this->enterprise->accessGroupId;
            if (!$authenticated) {
                return new ViewModel([
                    'error' => "Incorrect username and/or password"
                ]);
            } else {
                $job = "4000+" . $sc_group_id;
                if (canAccessEnvironment($sc_group_id)) {
                    $job = "";
                    global $defaultHomepages;
                    if(sizeof($defaultHomepages) > 0) {
                        db_pf_field_load_by_name($defaultHomepages[0],'sc_job_id',$job);
                    }
                    return new ViewModel([
                        'success' => "Authenticated",
                        'url' => "/reservation.php?" . $job
                    ]);
                } else {
                    return new ViewModel([
                        'success' => "Authenticated",
                        'url' => "/reservation.php?4000+" . $sc_group_id
                    ]);
                }
            }
        } else {
            return new ViewModel([
                'error' => "Empty username and/or password"
            ]);
        }
    }

    private function emailSend()
    {
        if (
            !empty($this->params['emailTo']) &&
            !empty($this->params['emailFrom']) &&
            !empty($this->params['emailSubject']) &&
            !empty($this->params['emailMessage'])
        ) {
            require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/class.mysqldb.php');
            require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/inc.setup.php');
            require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/functions.php');
            require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/functions.system.php');
            require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/functions.mail.php');
            require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/ac_logon.php');

            $result = email(
                $this->params['emailFrom'],
                $this->params['emailTo'],
                $this->params['emailSubject'],
                '',
                $this->params['emailMessage']
            );
            return new ViewModel([
                'sendResult' => !$result
            ]);
        } else {
            return new ViewModel([
                'notAllFieldsFilledIn' => true
            ]);
        }
    }
}
