<?php

namespace Resrequest\API\V1\Rpc\MinLosAddRule;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class MinLosAddRuleController extends AbstractActionController
{
    private $db;
    private $auth;

    public function __construct($em, $auth)
    {
        $this->db = $em->getConnection();
        $this->auth = $auth;
    }

    public function minLosAddRuleAction()
    {
        $params = $this->bodyParams();


        $minLos = $params['minLos'];
        $lapseLeadNights = $params['lapseLeadNights'];
        $description = $params['description'];
        $applyToAllocations = isset($params['applyToAllocations']) ? $params['applyToAllocations'] : "0";
        $minLosDays = $params['minLosDays'];

        $rateTypes = isset($params['rateTypes']) ? $params['rateTypes'] : false;
        $ratePeriods = isset($params['ratePeriods']) ? $params['ratePeriods'] : false;
        $accommodationTypes = isset($params['accommodationTypes']) ? $params['accommodationTypes'] : false;
        $agents = isset($params['agents']) ? $params['agents'] : false;


        // Update rule
        $result = $this->db->executeQuery("
            INSERT INTO ml_rule (
                ml_rule.ml_min_los,
                ml_rule.ml_lapse_days,
                ml_rule.ml_rule_desc,
                ml_rule.ml_allocations_yn,
                ml_rule.ml_days_of_week
            ) VALUES (
                ?,
                ?,
                ?,
                ?,
                ?
            )
        ", [
            $minLos,
            $lapseLeadNights,
            $description,
            $applyToAllocations,
            join(',', $minLosDays)
        ]);

        $id = $this->db->fetchAssoc('SELECT @last_insert_id;')['@last_insert_id'];

        if ($rateTypes !== false) {
            $insertRateTypes = $this->db->prepare("
                INSERT INTO ml_rate_type
                (
                    ml_rule_id,
                    rt_rate_type_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($rateTypes as $rateTypeId) {
                $insertRateTypes->bindValue(1, $id);
                $insertRateTypes->bindValue(2, $rateTypeId);
                $insertRateTypes->execute();
            }
        }

        if ($ratePeriods !== false) {
            $insertRatePeriods = $this->db->prepare("
                INSERT INTO ml_period
                (
                    ml_rule_id,
                    rt_period_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($ratePeriods as $ratePeriodId) {
                $insertRatePeriods->bindValue(1, $id);
                $insertRatePeriods->bindValue(2, $ratePeriodId);
                $insertRatePeriods->execute();
            }
        }

        if ($ratePeriods !== false) {
            $insertRatePeriods = $this->db->prepare("
                INSERT INTO ml_period
                (
                    ml_rule_id,
                    rt_period_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($ratePeriods as $ratePeriodId) {
                $insertRatePeriods->bindValue(1, $id);
                $insertRatePeriods->bindValue(2, $ratePeriodId);
                $insertRatePeriods->execute();
            }
        }


        if ($accommodationTypes !== false) {
            $insertAccommodationTypes = $this->db->prepare("
                INSERT INTO ml_accomm
                (
                    ml_rule_id,
                    ac_accomm_type_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($accommodationTypes as $accommodationTypeId) {
                $insertAccommodationTypes->bindValue(1, $id);
                $insertAccommodationTypes->bindValue(2, $accommodationTypeId);
                $insertAccommodationTypes->execute();
            }
        }


        if ($agents !== false) {
            $insertAgents = $this->db->prepare("
                INSERT INTO ml_agent
                (
                    ml_rule_id,
                    pr_agent_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($agents as $agentId) {
                $insertAgents->bindValue(1, $id);
                $insertAgents->bindValue(2, $agentId);
                $insertAgents->execute();
            }
        }


        return new JsonModel(['success' => true, 'id' => $id]);
    }
}
