<?php

namespace Resrequest\API\V1\Rpc\MinLosDeleteRule;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class MinLosDeleteRuleController extends AbstractActionController
{
    private $db;
    private $auth;

    public function __construct($em, $auth)
    {
        $this->db = $em->getConnection();
        $this->auth = $auth;
    }

    public function minLosDeleteRuleAction()
    {
        $params = $this->bodyParams();

        $id = $params['id'];

        // Delete rule
        $result = $this->db->executeQuery("
            DELETE FROM ml_rule WHERE ml_rule.ml_rule_ix = ?
        ", [
            $id
        ]);

        $deleteRateTypes = $this->db->executeQuery("
                DELETE FROM ml_rate_type WHERE ml_rate_type.ml_rule_id = ?
            ", [
            $id
        ]);

        $deleteRatePeriods = $this->db->executeQuery("
                DELETE FROM ml_period WHERE ml_period.ml_rule_id = ?
            ", [
            $id
        ]);

        $deleteAccommodationTypes = $this->db->executeQuery("
                DELETE FROM ml_accomm WHERE ml_accomm.ml_rule_id = ?
            ", [
            $id
        ]);

        $deleteAgents = $this->db->executeQuery("
                DELETE FROM ml_agent WHERE ml_agent.ml_rule_id = ?
            ", [
            $id
        ]);

        return new JsonModel(['success' => true]);
    }
}
