<?php

namespace Resrequest\API\V1\Rpc\MinLosEditRule;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class MinLosEditRuleController extends AbstractActionController
{
    private $db;
    private $auth;

    public function __construct($em, $auth)
    {
        $this->db = $em->getConnection();
        $this->auth = $auth;
    }

    public function minLosEditRuleAction()
    {
        $params = $this->bodyParams();


        $id = $params['id'];

        $minLos = $params['minLos'];
        $lapseLeadNights = $params['lapseLeadNights'];
        $description = $params['description'];
        $applyToAllocations = $params['applyToAllocations'];
        $minLosDays = $params['minLosDays'];

        $rateTypes = isset($params['rateTypes']) ? $params['rateTypes'] : false;
        $ratePeriods = isset($params['ratePeriods']) ? $params['ratePeriods'] : false;
        $accommodationTypes = isset($params['accommodationTypes']) ? $params['accommodationTypes'] : false;
        $agents = isset($params['agents']) ? $params['agents'] : false;


        $rule = $this->db->executeQuery("
            SELECT * FROM ml_rule WHERE ml_rule_ix = ?
        ", [
            $id
        ]);

        if (empty($rule)) {
            return new ApiProblemResponse(
                new ApiProblem(400, 'Invalid rule')
            );
        }


        // Update rule
        $result = $this->db->executeQuery("
            UPDATE
                ml_rule
            SET
                ml_rule.ml_min_los = ?,
                ml_rule.ml_lapse_days = ?,
                ml_rule.ml_rule_desc = ?,
                ml_rule.ml_allocations_yn = ?,
                ml_rule.ml_days_of_week = ?
            WHERE
                ml_rule.ml_rule_ix = ?
        ",[
            $minLos,
            $lapseLeadNights,
            $description,
            $applyToAllocations,
            join(',', $minLosDays),

            $id
        ]);

        if ($rateTypes !== false) {
            $deleteRateTypes = $this->db->executeQuery("
                DELETE FROM ml_rate_type WHERE ml_rate_type.ml_rule_id = ?
            ", [
                $id
            ]);

            $insertRateTypes = $this->db->prepare("
                INSERT INTO ml_rate_type
                (
                    ml_rule_id,
                    rt_rate_type_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($rateTypes as $rateTypeId) {
                $insertRateTypes->bindValue(1, $id);
                $insertRateTypes->bindValue(2, $rateTypeId);
                $insertRateTypes->execute();
            }
        }

        if ($ratePeriods !== false) {
            $deleteRatePeriods = $this->db->executeQuery("
                DELETE FROM ml_period WHERE ml_period.ml_rule_id = ?
            ", [
                $id
            ]);

            $insertRatePeriods = $this->db->prepare("
                INSERT INTO ml_period
                (
                    ml_rule_id,
                    rt_period_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($ratePeriods as $ratePeriodId) {
                $insertRatePeriods->bindValue(1, $id);
                $insertRatePeriods->bindValue(2, $ratePeriodId);
                $insertRatePeriods->execute();
            }
        }

        if ($ratePeriods !== false) {
            $deleteRatePeriods = $this->db->executeQuery("
                DELETE FROM ml_period WHERE ml_period.ml_rule_id = ?
            ", [
                $id
            ]);

            $insertRatePeriods = $this->db->prepare("
                INSERT INTO ml_period
                (
                    ml_rule_id,
                    rt_period_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($ratePeriods as $ratePeriodId) {
                $insertRatePeriods->bindValue(1, $id);
                $insertRatePeriods->bindValue(2, $ratePeriodId);
                $insertRatePeriods->execute();
            }
        }


        if ($accommodationTypes !== false) {
            $deleteAccommodationTypes = $this->db->executeQuery("
                DELETE FROM ml_accomm WHERE ml_accomm.ml_rule_id = ?
            ", [
                $id
            ]);

            $insertAccommodationTypes = $this->db->prepare("
                INSERT INTO ml_accomm
                (
                    ml_rule_id,
                    ac_accomm_type_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($accommodationTypes as $accommodationTypeId) {
                $insertAccommodationTypes->bindValue(1, $id);
                $insertAccommodationTypes->bindValue(2, $accommodationTypeId);
                $insertAccommodationTypes->execute();
            }
        }


        if ($agents !== false) {
            $deleteAgents = $this->db->executeQuery("
                DELETE FROM ml_agent WHERE ml_agent.ml_rule_id = ?
            ", [
                $id
            ]);

            $insertAgents = $this->db->prepare("
                INSERT INTO ml_agent
                (
                    ml_rule_id,
                    pr_agent_id
                )
                VALUES
                (
                    ?,
                    ?
                )
            ");

            foreach ($agents as $agentId) {
                $insertAgents->bindValue(1, $id);
                $insertAgents->bindValue(2, $agentId);
                $insertAgents->execute();
            }
        }


        return new JsonModel([
            'success' => true
        ]);
    }
}
