<?php
namespace Resrequest\API\V1\Rpc\MinLosGetMinLos;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class MinLosGetMinLosController extends AbstractActionController
{
    private $legacy;
    private $auth;

    public function __construct($em, $auth)
    {
        $this->auth = $auth;
        $this->legacy = __DIR__."/../../../../../../../Application/src/Resrequest/legacy/";
        $this->entityManager = $em;
    }

    public function minLosGetMinLosAction()
    {
        $username = false;
        $userId = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if ($username === false) {
            $userId = $this->entityManager->getConnection()->fetchAll("SELECT pr_persona.pr_persona_ix FROM pr_persona WHERE pr_sys_code = 7");
            if(empty($userId)) {
                return new ApiProblemResponse(
                    new ApiProblem(400, "Unable to find public user")
                );
            } else {
                $userId = $userId[0]['pr_persona_ix'];
            }
        } else {
            $user = $this->auth->getUserByName($username);
            $this->auth->setupContext($user);
            $userId = $user['pr_user_id'];
        }

        require_once($this->legacy . 'class.minlos.php');

        $params = $this->bodyParams();
        $accommodationTypes = $params['accommodationTypes'];
        $startDate = $params['startDate'];
        $endDate = $params['endDate'];
        $rateType = $params['rateType'];

        $userQuery = $this->entityManager->createQueryBuilder();
        $groupId = $userQuery
            ->select('scUserTable.scGroupId AS groupId')
            ->from('Resrequest\DB\Enterprise\Entity\PrUser', 'prUserTable')
            ->innerJoin(
                'Resrequest\DB\Enterprise\Entity\ScUser',
                'scUserTable',
                'with',
                'scUserTable.prUserId = prUserTable.prUserId'
            )
            ->where('prUserTable.prUserId = :userId')
            ->setParameter('userId', $userId)
            ->getQuery()
            ->getSingleScalarResult();

        $accommodationQuery = $this->entityManager->createQueryBuilder();
        $accommodations = $accommodationQuery
            ->select(
                'acAccommTypeTable.acAccommTypeIx AS id',
                'acAccommTypeTable.acAccommDesc AS name',
                'acAccommTypeTable.acAccommTypeInactiveYn AS inactive'
            )
            ->from('Resrequest\DB\Enterprise\Entity\ScAccomm', 'scAccommTable')
            ->innerJoin(
                'Resrequest\DB\Enterprise\Entity\AcAccommType',
                'acAccommTypeTable',
                'with',
                'acAccommTypeTable.acAccommTypeIx = scAccommTable.acAccommTypeId'
            )
            ->where('scAccommTable.scGroupId = :groupId')
            ->andWhere('acAccommTypeTable.acAccommTypeIx IN(:accommodationTypes)')
            ->setParameters(
                [
                    'groupId' => $groupId,
                    'accommodationTypes' => $accommodationTypes
                ]
            )
            ->distinct()
            ->getQuery()
            ->getResult();

        $allowedAccomms = array_column($accommodations, 'id');

        $result = [];
        foreach ($allowedAccomms as $id) {
            if (!isset($result[$id])) {
                $result[$id] = [
                    'minLos' => null
                ];

                $minLos = new \MinLOS($id, $startDate, $endDate, $rateType, $userId);
                $result[$id] = $minLos->getMinLOSByDay();
            }
        }

        return new JsonModel($result);
    }
}
