<?php
namespace Resrequest\API\V1\Rpc\NotificationAddNotification;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

class NotificationAddNotificationController extends AbstractActionController
{
    protected $em, $password;
    private $params;

    public function __construct($em, $enterprise)
    {
        $this->em = $em;
        $this->password = $enterprise->passwords['notifications'];
    }

    public function notificationAddNotificationAction()
    {
        $this->params = $this->bodyParams();

        if (!isset($this->params['securityHash']) || $this->params['securityHash'] !== $this->password) {
            return new ViewModel(['data' => '', 'error' => 'Invalid security hash', 'code' => 401]); // Unauthorized
        }

        $db = $this->em->getConnection();
        $sql = "";

        $pr_notification_id = $this->params['data']['pr_notification_id'];
        $sql .= "
            INSERT INTO pr_notification (
                pr_notification_db,
                pr_notification_ix,
                pr_notification_subject,
                pr_notification_message,
                pr_notification_added,
                pr_notification_added_by
            ) VALUES (
                'WB',
                '" . $pr_notification_id . "',
                '" . $this->params['data']['message']['subject'] . "',
                :messageBody,
                CURRENT_TIMESTAMP,
                '" . $this->params['data']['message']['user'] . "'
            );
        ";

        foreach ($this->params['data']['users'] AS $user_id) {
            $sql .= "
                INSERT INTO pr_notification_target (
                    pr_notification_target_ix,
                    pr_notification_target_db,
                    pr_notification_id,
                    pr_user_id
                ) VALUES (
                    (SELECT GET_UUID()),
                    'WB',
                    '" . $pr_notification_id . "',
                    '" . $user_id . "'
                );
            ";
        }

        $insertNotification = $db->prepare($sql);
        $insertNotification->bindValue("messageBody", $this->params['data']['message']['body']);
        $insertNotification->execute();

        return new ViewModel([
            'status' => 'success'
        ]);
    }
}
