<?php
namespace Resrequest\API\V1\Rpc\NotificationGetReceipts;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

class NotificationGetReceiptsController extends AbstractActionController
{
    protected $em, $password;
    private $params;

    public function __construct($em, $enterprise)
    {
        $this->em = $em;
        $this->password = $enterprise->passwords['notifications'];
    }

    public function notificationGetReceiptsAction()
    {
        $this->params = $this->bodyParams();

        if (!isset($this->params['securityHash']) || $this->params['securityHash'] !== $this->password) {
            return new ViewModel(['data' => '', 'error' => 'Invalid security hash', 'code' => 401]); // Unauthorized
        }

        $db = $this->em->getConnection();
        $receipts = $db->fetchAll("
            SELECT
                pr_notification_receipt.pr_notification_receipt_delivered_timestamp AS 'delivered',
                pr_notification_receipt.pr_notification_receipt_read_timestamp AS 'read',
                pr_notification_receipt.pr_notification_receipt_acknowledged_timestamp AS 'acknowledged',
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS 'name'
            FROM
                pr_notification_target
                LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = pr_notification_target.pr_user_id
                LEFT JOIN pr_notification_receipt ON
                    pr_notification_receipt.pr_notification_id = pr_notification_target.pr_notification_id
                    AND pr_notification_receipt.pr_user_id = pr_notification_target.pr_user_id
            WHERE
                pr_notification_target.pr_notification_id = '" . $this->params['data']['notification_id'] . "'
            ORDER BY
                pr_persona.pr_name_first ASC
        ");

        return new ViewModel([
            'receipts' => $receipts
        ]);
    }
}
