<?php
namespace Resrequest\API\V1\Rpc\NotificationsGetUsers;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

class NotificationsGetUsersController extends AbstractActionController
{
    protected $em, $password;
    private $params;

    public function __construct($em, $enterprise)
    {
        $this->em = $em;
        $this->password = $enterprise->passwords['notifications'];
    }

    public function notificationsGetUsersAction()
    {
        $this->params = $this->bodyParams();

        if (!isset($this->params['securityHash']) || $this->params['securityHash'] !== $this->password) {
            return new ViewModel(['data' => '', 'error' => 'Invalid security hash', 'code' => 401]); // Unauthorized
        }

        $db = $this->em->getConnection();
        $users = $db->fetchAll("
            SELECT
                pr_user.pr_user_id AS 'id',
                TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last)) AS 'name',
                IF(pr_link.pr_link_ix IS NOT NULL, 1, 0) AS 'internal',
                sc_group.sc_group_id AS 'usergroup_id',
                sc_group.sc_grp_desc AS 'usergroup_name',
                IF (rf_sys_admin.rf_sys_admin_ix IS NOT NULL, '1', '0') AS 'sysadmin'
            FROM
                pr_user
                INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_user.pr_user_id
                LEFT JOIN pr_link ON pr_link_from = pr_user.pr_user_id AND rf_link_type_id = 'RS1'
                LEFT JOIN sc_user ON sc_user.pr_user_id = pr_user.pr_user_id
                LEFT JOIN sc_group ON sc_group.sc_group_id = sc_user.sc_group_id
                LEFT JOIN rf_default ON rf_default.rf_sys_admin_id = pr_user.pr_user_id
                LEFT JOIN rf_sys_admin ON rf_sys_admin.pr_persona_id = pr_user.pr_user_id
            WHERE
                pr_user.pr_user_inactive_yn = 0
                AND pr_persona.pr_sys_code < 6
            ORDER BY
                pr_persona.pr_name_first ASC
        ");
        
        $usergroups = $db->fetchAll("
            SELECT
                sc_group_id AS 'id',
                sc_grp_desc AS 'name'
            FROM
                sc_group
            WHERE
                sc_grp_inactive_yn = 0
            ORDER BY
                sc_grp_desc ASC
        ");

        return new ViewModel([
            'users' => $users,
            'usergroups' => $usergroups
        ]);
    }
}
