<?php
namespace Resrequest\API\V1\Rpc\OauthTokenRefresh;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class OauthTokenRefreshController extends AbstractActionController
{
    protected $authenticateService;

    public function __construct($authenticateService)
    {
        $this->authenticateService = $authenticateService;
    }

    public function oauthTokenRefreshAction()
    {
        if (empty($_COOKIE['rrq_token'])) {
            $result = false;
        } else {
            $result = $this->authenticateService->refreshTokenByCookie($_COOKIE['rrq_token']);
        }
        
        if ($result === false) {
            return $this->error("Invalid refresh token specified", 401);
        }

        return new JsonModel($result);
    }

    public function error($message, $code=403)
    {
        return new ApiProblemResponse(
             new ApiProblem($code, $message)
        );
    }
}
