<?php
namespace Resrequest\API\V1\Rpc\Ping;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/inc.setup.php');

class PingController extends AbstractActionController
{
    protected $em;
    protected $authoriseService;
    protected $enterprise;

    public function __construct($em, $authoriseService, $enterprise)
    {
        $this->em = $em;
        $this->authoriseService = $authoriseService;
        $this->enterprise = $enterprise;
    }

    public function pingAction()
    {
        $username = "";
        $identity = $this->getIdentity();
        if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        $name = "Unknown";
        $userId = '';

        if(!empty($username)) {
            $db = $this->em->getConnection();
            $name = $db->fetchColumn("
                SELECT
                    TRIM(CONCAT(pr_persona.pr_name_first, ' ', pr_persona.pr_name_last))
                FROM
                    pr_user
                    INNER JOIN pr_persona ON pr_persona.pr_persona_ix = pr_user.pr_user_id
                WHERE
                    pr_user.pr_user_name = ?
            ",[$username]);
            $userId = $db->fetchColumn("
                SELECT
                    pr_user_id
                FROM
                    pr_user
                WHERE
                    pr_user.pr_user_name = ?
            ",[$username]);
        }

        // TODO: Replace legacy method of getting userStatusId when available
        // 3 = System (special), 2 = Internal, 1 = External/Agent, 0 = Basic/Public
        $userStatusId = isset($_SESSION['userStatusId']) ? $_SESSION['userStatusId'] : "";

        /* TODO implement bulk access check
        $test = $this->authoriseService->getAccess([
            'routes'=>["/rooming"],
            'functions'=>[66]
        ]);
        */

        $query = $this->em->createQueryBuilder();
        $principalName = $query
            ->select(
                [
                    "TRIM(CONCAT(prPersona.prNameFirst, ' ', prPersona.prNameLast)) AS name"
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfDefault', 'rfDefault')
            ->innerJoin('Resrequest\DB\Enterprise\Entity\PrPersona', 'prPersona', 'with', 'prPersona.prPersonaIx = rfDefault.rfPrincipalId')
            ->getQuery()
            ->getResult();
        $principalName = $principalName[0]['name'];

        return new ViewModel([
            'ack'=>time(),
            'principal'=>"TODO: Get principal", //$GLOBALS['principal'],
            'principalName' => $principalName,
            'systemVersion' => getSystemVersion(),
            'environment' => $this->enterprise->config['environment'],
            'client' => $GLOBALS['client'],
            'user'=>[
                'username' => $username,
                'user_id' => $userId,
                'name' => $name,
                'status_id' => $userStatusId
            ],
        ]);
    }
}
