<?php
namespace Resrequest\API\V1\Rpc\PublicCheckInGuests;

use Resrequest\API\PublicUser;
use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

define('GUEST_CHECK_IN_SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))))); //Go back 5 directories
define('GUEST_CHECK_IN_ROOT', GUEST_CHECK_IN_SERVER. '/Application/src/Resrequest/legacy');
class PublicCheckInGuestsController extends AbstractActionController
{
	use PublicUser;

    public function __construct($em, $auth)
    {
        $this->em = $em;
        $this->auth = $auth;
		$this->legacy = __DIR__."/../../../../../../../Application/src/Resrequest/legacy/";
    }

    public function publicCheckInGuestsAction()
    {
		$login = $this->publicUserGuestLogin();
		if($login !== true) {
			return $login;
		}

        $params = $this->bodyParams();
        $db = $this->em->getConnection();

		$rv_reservation_id = $params['reservation_id'];
		$email = $params['email'];

		// Validate parameters
		if(!array_key_exists("guests", $params)) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid payload missing guests.")
			);
		}
		$guests = $params['guests'];
		if(!is_array($guests) || sizeof($guests) < 1) {
			return new ApiProblemResponse(
				new ApiProblem(400, "Invalid payload missing guests.")
			);
		}
		$allowedGuests = $db->executeQuery("
			SELECT DISTINCT
				rv_res_item_guest.pr_guest_id AS id
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_reservation_id = ?
				AND pr_persona.pr_email = ?
			ORDER BY
				rv_res_item_group.rv_res_item_group_ix
		",[
			$rv_reservation_id,
			$email
		])->fetchAll(\PDO::FETCH_COLUMN);
		if($allowedGuests === false || empty($allowedGuests)) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}

		$guestFieldsQuery = $this->em->createQueryBuilder();
        $guestFields = $guestFieldsQuery
            ->select(
                [
                    'guestField.rfObjRegistrationCardName AS name',
                    'guestField.rfObjRegistrationCardMandatoryYn AS compulsory',
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfObjRegistrationCard', 'guestField')
            ->where('guestField.rfObjRegistrationCardSysCode IN(1,2)')
            ->orderBy('guestField.rfObjRegistrationCardSortSeq')
            ->getQuery()
			->getResult();

		$fieldsDescription = [
			'first_name' => "first name",
			'last_name' => "last name",
			'birth_date' => "birth date",
			'email' => "email",
			'mobile_number' => "mobile number",
			'passport_number' => "passport number",
			'notes_append' => "extra notes",
			'covid_yn' => "covid statement",
		];

		// Map available fields to rf_obj_registration_card fields
		$fieldMap = [
			'first_name' => "guest_name_first",
			'last_name' => "guest_name_last",
			'birth_date' => "guest_birthdate",
			'covid_yn' => "covid_exposure",
			'email' => "guest_email",
			'mobile_number' => "guest_phone_number",
			'passport_number' => "guest_passport_number",
			'notes_append' => "guest_note"
		];
		
		
		$required = [
			'id' => "guest id",
		];
		$optional = [];

		foreach ($guestFields as $field) {
			if (in_array($field['name'], $fieldMap)) {
				$key = array_search($field['name'], $fieldMap);
				if (empty($field['compulsory'])) {
					$optional[$key] = $fieldsDescription[$key];
				} else {
					$required[$key] = $fieldsDescription[$key];
				}
			}
		}

		foreach($guests as &$guest) {
			if(!is_array($guest) || empty($guest)) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Invalid payload missing guest.")
				);
			}
			foreach($required as $field=>$name) {
				if(!array_key_exists($field, $guest) || trim($guest[$field]) == "") {
					return new ApiProblemResponse(
						new ApiProblem(400, "Invalid payload missing " . $name . ".")
					);
				}
			}
			foreach($optional as $field=>$name) {
				if(!array_key_exists($field, $guest)) {
					$guest[$field] = "";
				}
			}
			if(!in_array($guest['id'], $allowedGuests)) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Invalid guest id.")
				);
			}
			if(empty($guest['item_id'])) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Invalid guest item id.")
				);
			}
			if(trim($guest['email']) == "" && trim($guest['mobile_number']) == "") {
				return new ApiProblemResponse(
					new ApiProblem(400, "Invalid payload missing guest contact information.")
				);
			}
			if(trim($guest['email']) != "" && !preg_match("/.+@.+\..+/", $guest['email'])) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Invalid payload invalid guest email.")
				);
			}

			if (in_array('birth_date', $required)) {
				$birth = strtotime($guest['birth_date']);
				if($birth === false) {
					return new ApiProblemResponse(
						new ApiProblem(400, "Invalid payload invalid guest birth date.")
					);
				} else {
					$guest['birth_date'] = date("Y-m-d", $birth);
				}
			}
		}
		unset($guest);

		// Save guests
		require_once($this->legacy . "class.audit.php");
		require_once($this->legacy . "db.pr_guest_obj_data.php");
		require_once($this->legacy . "db.pr_persona.php");
		require_once($this->legacy . "db.pr_phone.php");
		require_once($this->legacy . "db.rf_obj_guest.php");

		require_once($this->legacy . "db.rf_obj_registration_card.php");
		require_once($this->legacy . "db.rv_registration_card_obj_data.php");
		require_once($this->legacy . "db.rv_registration_card.php");

		$rf_res_office_id = $db->fetchAssoc("select rf_res_office_id from rf_default where rf_default_id = '1'")['rf_res_office_id'];
		$resOfficeContact = $db->fetchAssoc("
			SELECT
				pr_email,
				pr_phone_number,
				pr_web_addr
			FROM
				pr_persona
				INNER JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix
			WHERE pr_persona_ix = ?
		", [$rf_res_office_id]);

		foreach($guests as $guest) {
			$groupId = $db->executeQuery("
				SELECT DISTINCT
					rv_res_item_group.rv_res_item_group_ix as rv_res_item_group_id
				FROM
					rv_res_item_guest
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				WHERE
					rv_reservation_item.rv_reservation_item_ix = ?
					AND pr_persona.pr_persona_ix = ?
				ORDER BY
					rv_res_item_group.rv_res_item_group_ix
			",[
				$guest['item_id'],
				$guest['id']
			])->fetchAll(\PDO::FETCH_ASSOC)[0]['rv_res_item_group_id'];

			$itemDetails = $db->fetchAssoc("
				SELECT DISTINCT
					rv_reservation_item.rv_reservation_id AS rv_reservation_id,
					rv_reservation_item.rv_item_accomm_count AS accomm_count,
					rv_reservation_item.rv_item_adult_count AS adult_count,
					rv_reservation_item.rv_item_child_count AS child_count,
					rv_reservation_item.rv_item_date_arrive AS from_date,
					rv_reservation_item.rv_item_date_depart AS to_date,
					rv_reservation_item.pr_business_id
				FROM
					rv_res_item_group
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				WHERE
					rv_res_item_group.rv_res_item_group_ix = ?
			",[
				$groupId,
			]);
			
			if (empty($cardId = db_rv_registration_card_exists_by_registration_card($groupId, $guest['id']))) {
				$cardId = db_rv_registration_card_insert($groupId, $guest['id']);
			} else {
				db_rv_registration_card_update($cardId);
			}

			$changes = [
				'pr_name_first'=>$guest['first_name'],
				'pr_name_last'=>$guest['last_name']
			];
			$this->setCardObj($cardId, 'guest_name_first', $guest['first_name']);
			$this->setCardObj($cardId, 'guest_name_last', $guest['last_name']);

			if(!empty($guest['email'])) {
				$changes['pr_email'] = $guest['email'];
				$this->setCardObj($cardId, 'guest_email', $guest['email']);
			}
			try {
				db_pr_persona_update_custom($guest['id'], $changes);
			} catch(Exception $e) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Unable to update guest: " . $e->getMessage())
				);
			}

			if(!empty($guest['mobile_number'])) {
				$rf_mobile_type_id = $db->fetchColumn("
					SELECT
						rf_phone_type.rf_phone_type_ix
					FROM
						rf_phone_type
					WHERE
						rf_phone_type.rf_phone_type_desc LIKE '%mobile%'
				");
				if($rf_mobile_type_id === false || empty($rf_mobile_type_id)) {
					return new ApiProblemResponse(
						new ApiProblem(400, "Unable to find mobile phone type")
					);
				}

				$pr_mobile_id = $db->fetchColumn("
					SELECT
						pr_phone.pr_phone_ix
					FROM
						pr_phone
					WHERE
						pr_phone.pr_persona_id = ?
						AND pr_phone.rf_phone_type_id = ?
				",[
					$guest['id'],
					$rf_mobile_type_id
				]);
				$this->setCardObj($cardId, 'guest_phone_number', $guest['mobile_number']);
				if($pr_mobile_id === false) { // Create a new phone entry
					db_pr_phone_insert($guest['id'], $rf_mobile_type_id,$guest['mobile_number'], false, true);
				} else { // Update existing phone entry
					db_pr_phone_update($pr_mobile_id,$rf_mobile_type_id,$guest['mobile_number'], false, true);
				}
			}

			$rf_obj_birthdate_id = $db->fetchColumn("SELECT rf_obj_guest_ix FROM rf_obj_guest WHERE rf_obj_guest_sys_code = '2'");
			$rf_obj_note_id = $db->fetchColumn("SELECT rf_obj_guest_ix FROM rf_obj_guest WHERE rf_obj_guest_sys_code = '5'");
			$rf_obj_passport_id = $db->fetchColumn("SELECT rf_obj_guest_ix FROM rf_obj_guest WHERE rf_obj_guest_sys_code = '8'");
			if(empty($rf_obj_birthdate_id) || empty($rf_obj_note_id) || empty($rf_obj_passport_id)) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Unable to find guest fields")
				);
			}

			$audit = new \AuditTrail($guest['id'],TYPE_PERSONA);
			
			$this->setGuestObj($audit, $guest['id'], $rf_obj_birthdate_id, $guest['birth_date']);
			$this->setCardObj($cardId, 'guest_birthdate', $guest['birth_date']);
			db_pr_persona_update_birthdate($guest['id'], $guest['birth_date']);

			if($guest['passport_number'] != "") {
				$this->setGuestObj($audit, $guest['id'], $rf_obj_passport_id, $guest['passport_number']);
				$this->setCardObj($cardId, 'guest_passport_number', $guest['passport_number']);
				db_pr_persona_update_identity($guest['id'],$guest['passport_number']);
			}

			$notes = [];
			$oldNote = $db->fetchColumn("SELECT pr_guest_note FROM pr_guest WHERE pr_guest_id = ?",[$guest['id']]);
			if(!empty($oldNote)) {
				$notes[] = $oldNote;
			}
			if(!empty($guest['notes_append'])) {
				$notes[] =  $guest['notes_append'];
			}
			$notes[] = (new \DateTime())->format('d F Y') . " - Online Check-in Have you been exposed to Covid in the last 14 days: " . (empty($guest['covid_yn']) ? "No" : "Yes");
			$newNote = join("\n\n",$notes);

			$this->setGuestObj($audit, $guest['id'], $rf_obj_note_id, $newNote);
			$this->setCardObj($cardId, 'guest_note', $newNote);

			if (!is_null($guest['covid_yn'])) {
				if (empty($guest['covid_yn'])) {
					$covidExposure = 'No';
				} else {
					$covidExposure = 'Yes';
				}
				$this->setCardObj($cardId, 'covid_exposure', $covidExposure);
			}

			db_pr_guest_set_note($guest['id'], $newNote);

			$audit->save("Guest details (Edit)");

			$data = $itemDetails;
			$data['res_office_phone'] = $resOfficeContact['pr_phone_number'];
			$data['res_office_email'] = $resOfficeContact['pr_email'];

			$data['guest_first_name'] = $guest['first_name'];
			$data['guest_last_name'] = $guest['last_name'];

			$reservationDetails = $db->fetchAssoc("
				SELECT
					consultant.pr_email as consultantEmail,
					rv_reservation.rv_res_name as reservationName
				FROM
					rv_reservation
					INNER JOIN pr_persona AS consultant ON consultant.pr_persona_ix = rv_reservation.rv_consultant_id
				WHERE
					rv_reservation.rv_reservation_ix = ?
			", [$data['rv_reservation_id']]);

			$data['consultant_email'] = $reservationDetails['consultantEmail'];
			$data['reservation_name'] = $reservationDetails['reservationName'];
			
			$propertyContact = $db->fetchAssoc("
				SELECT
					pr_email,
					pr_phone_number,
					pr_web_addr,
					pr_name_last AS business_name
				FROM
					pr_persona
					INNER JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix
				WHERE pr_persona_ix = ?
			", [$itemDetails['pr_business_id']]);

			$data['pr_web_addr'] = $propertyContact['pr_web_addr'];
			$data['business_name'] = $propertyContact['business_name'];

			$this->sendEmail($email, $data);
		}

		return new JsonModel([
			'status'=>true
		]);
	}
	

	protected function setCardObj($rv_registration_card_id, $obj_name, $value)
	{
		$obj_id = db_rf_obj_registration_card_by_name($obj_name);
		db_rv_registration_card_obj_data_insert($obj_id, $rv_registration_card_id, $value, 2);
	}

	protected function setGuestObj($audit, $pr_persona_id, $rf_obj_guest_id, $value)
	{
		$newAll = db_rf_obj_guest_get_all($rf_obj_guest_id, $value);
		if(db_pr_guest_obj_data_exists_by_guest($pr_persona_id, $rf_obj_guest_id)) {
			$pr_guest_obj_data_id = db_pr_guest_obj_data_select_by_guest($pr_persona_id, $rf_obj_guest_id);
			$oldAll = db_pr_guest_obj_data_get_all($pr_guest_obj_data_id);
			db_pr_guest_obj_data_update($pr_guest_obj_data_id, $rf_obj_guest_id, $value);
			$audit->addDetail($oldAll['id'], $newAll['id'], $pr_guest_obj_data_id, $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_EDIT, "guest", "pr_guest_obj_data.", $rf_obj_guest_id, $oldAll['value'], $newAll['value']);
		} else {
			$pr_guest_obj_data_id = db_pr_guest_obj_data_insert($pr_persona_id, $rf_obj_guest_id, $value);
			$audit->addDetail("", $newAll['id'], "", $pr_guest_obj_data_id, DB_AD_PERSONA_DETAIL_ACTION_ADD, "guest", "pr_guest_obj_data.", $rf_obj_guest_id, "", $newAll['value']);
		}
	}

	function sendEmail($recipient, $data) {
		require_once(GUEST_CHECK_IN_ROOT . '/class.mysqldb.php');
		require_once(GUEST_CHECK_IN_ROOT . '/functions.mail.php');

		$message = $this->buildEmail($data);

		$failed = email(
			$data['res_office_email'],
			"$recipient",
			"Online check in successful ({$GLOBALS['principal_name']})",
			'',
			$message['guest'],
			0,
			0,
			'',
			$GLOBALS['principal_name'],
			'',
			'',
			false,
			false,
			50,
			true
		);

		$failed = email(
			$data['res_office_email'],
			$data['consultant_email'],
			"Online check in successful ({$GLOBALS['principal_name']})",
			'',
			$message['consultant'],
			0,
			0,
			'',
			$GLOBALS['principal_name'],
			'',
			'',
			false,
			false,
			50,
			true
		);
	}

	private function buildEmail($data) {
		$temp = [];

		$temp['principal_id'] = $GLOBALS['principal_id'];
		$temp['principal_name'] = $GLOBALS['principal_name'];
		$temp['referrer'] = $GLOBALS['domain'] . '/guest';
		$temp['images_dir_on_disk'] = $GLOBALS['images_dir_on_disk'];
		$temp['Domain'] = $GLOBALS['http'] . $GLOBALS['domain']; 
		$temp['LogoSrc'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/" . $GLOBALS['principal_id'] . "/top_clientlogo.gif";
		$temp['guestAppImage'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/" . $GLOBALS['principal_id'] . "/guest-app_email.jpg";
		
		$temp['rv_reservation_id'] = $data['rv_reservation_id'];
		$temp['business_name'] = $data['business_name'];
		$temp['rv_date_arrive'] = (new \DateTime($data['from_date']))->format('d M Y');
		$temp['rv_date_depart'] = (new \DateTime($data['to_date']))->format('d M Y');
		$temp['rateGroupQty'] = $data['adult_count'];
		$temp['rateGroupChildQty'] = "";
		if ($data['child_count'] > 0) {
			$temp['rateGroupChildQty'] = "
				<tr>
					<td style=\"color: #444444; font-size: 14px; line-height: 1.75; font-weight: 600;\">
						Children  
					</td>
					<td style=\"color: #444444; font-size: 14px; line-height: 1.75; padding: 5px;\">
						" . $data['child_count'] . "
					</td>
				</tr>
			";
		}
		$temp['reservationName'] = $data['reservation_name'];
		$temp['res_office_email'] = $data['res_office_email'];
		$temp['guestName'] = trim($data['guest_first_name'] . ' ' . $data['guest_last_name']);
		

		if ( $ret = parse_url($data['pr_web_addr']) ) {
			if ( !isset($ret["scheme"]) )
			{
			$data['pr_web_addr'] = "http://{$data['pr_web_addr']}";
			}
		}

		if (empty($data['guest_first_name'])) {
			$temp['guest_name'] = $data['guest_last_name'];
		} else {
			$temp['guest_name'] = $data['guest_first_name'];
		}

		$temp['pr_web_addr'] = $data['pr_web_addr'];
		$temp['hide_pr_web_addr'] = '';

		if (empty($temp['pr_web_addr'])) {
			$temp['hide_pr_web_addr'] = 'display:none;';
		}

		$templateGuest = file_get_contents(GUEST_CHECK_IN_SERVER . '/Application/public/html/template_guest_check_in_confirmation.htm');
		foreach ($temp as $key => $value){
			$templateGuest = str_replace("!$key!", $value, $templateGuest);
		}
		$templateConsultant = file_get_contents(GUEST_CHECK_IN_SERVER . '/Application/public/html/template_guest_check_in_confirmation_consultant.htm');
		foreach ($temp as $key => $value){
			$templateConsultant = str_replace("!$key!", $value, $templateConsultant);
		}

		return array(
			'guest' => $templateGuest,
			'consultant' => $templateConsultant
		);
	}

	public function template($template, $data) {
		foreach ($data as $key => $value){
			$template = str_replace("!$key!", $value, $template);
		}

		return $template;
	}
}
