<?php

namespace Resrequest\API\V1\Rpc\PublicGetGuestSettings;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\ViewModel;

class PublicGetGuestSettingsController extends AbstractActionController
{
    protected $em;

    public function __construct($em)
    {
        $this->em = $em;
    }

    public function publicGetGuestSettingsAction()
    {
        $guestFieldsQuery = $this->em->createQueryBuilder();
        $guestFields = $guestFieldsQuery
            ->select(
                [
                    'guestField.rfObjRegistrationCardIx AS id',
                    'guestField.rfObjRegistrationCardName AS name',
                    'guestField.rfObjRegistrationCardMandatoryYn AS compulsory',
                    'guestField.rfObjRegistrationCardSysCode AS code',
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfObjRegistrationCard', 'guestField')
            ->where('guestField.rfObjRegistrationCardSysCode IN(1,2)')
            ->orderBy('guestField.rfObjRegistrationCardSortSeq')
            ->getQuery()
            ->getResult();

        $rfDefault = $this->em->getRepository('Resrequest\DB\Enterprise\Entity\RfDefault')->findOneBy([]);
        $indemnityMessage = $rfDefault->getRfGuestIndemnityMessage();

        if (empty($indemnityMessage)) {
            $indemnityMessage = "Contact our reservation office for indemnity details.";
        }

        $resOfficeContactQuery = $this->em->createQueryBuilder();
        $resOfficeEmail = $resOfficeContactQuery
            ->select(
                [
                    'persona.prEmail',
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfDefault', 'default')
            ->innerJoin('Resrequest\DB\Enterprise\Entity\PrPersona', 'persona', 'with', 'persona.prPersonaIx = default.rfResOfficeId')
            ->where('default.rfDefaultId = 1')
            ->getQuery()
            ->getSingleScalarResult();

        $termsQuery = $this->em->createQueryBuilder();
        $terms = $termsQuery
            ->select(
                [
                    'custom.rfBookingInfo',
                ]
            )
            ->from('Resrequest\DB\Enterprise\Entity\RfCustom', 'custom')
            ->where('custom.rfCustomId = 1')
            ->getQuery()
            ->getSingleScalarResult();

        $search = array (
            "'<script[^>]*?>.*?</script>'si",  // Strip out javascript
            "'<[\/\!]*?[^<>]*?>'si",           // Strip out html tags
            "'([\r\n])[\s]+'",                 // Strip out white space
            "'&(quot|#34);'i",                 // Replace html entities
            "'&(amp|#38);'i",
            "'&(lt|#60);'i",
            "'&(gt|#62);'i",
            "'&(nbsp|#160);'i",
            "'&(iexcl|#161);'i",
            "'&(cent|#162);'i",
            "'&(pound|#163);'i",
            "'&(copy|#169);'i"
        );
        $replace = array (
            "",
            "",
            "\\1",
            "\"",
            "&",
            "<",
            ">",
            " ",
            chr(161),
            chr(162),
            chr(163),
            chr(169)
        );
    
        //TODO: Replace with str_ireplace in PHP5
        $terms =
                str_replace("</div>","\n",
                str_replace("</DIV>","\n",
                str_replace("</p>","\n",
                str_replace("</P>","\n",
                str_replace("<br>","\n",
                str_replace("<BR>","\n",
            urldecode($terms)))))));
        $terms = preg_replace ($search, $replace, $terms);	
        $terms = preg_replace_callback(                                  
            "'&#(\d+);'",
            function($matches) {
                return chr($matches[1]);
            },
            $terms
        );

        $propertiesIndemnityNotesResult = $this->em->getConnection()->executeQuery("
			SELECT
				pr_business_id,
				pr_bus_guest_indemnity_message AS note
			FROM
                pr_business
        ")->fetchAll();

        $propertiesIndemnityNotes = [];

        foreach ($propertiesIndemnityNotesResult as $note) {
            $propertiesIndemnityNotes[$note['pr_business_id']] = $note['note'];
        }

        require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/functions.imageset.php');
        $images_dir_on_disk = __DIR__ . "/../../../../../../../../../../images";

        return new ViewModel([
            'indemnityMessage' => $indemnityMessage,
            'fields' => $guestFields,
            'reservationOfficeEmail' => $resOfficeEmail,
            'principalId' => $GLOBALS['principal_id'],
            'terms' => $terms,
            'propertiesIndemnityNotes' => $propertiesIndemnityNotes,
            'isV3Imageset' => isV3Imageset($GLOBALS['principal_id'], $images_dir_on_disk)
        ]);
    }
}
