<?php
namespace Resrequest\API\V1\Rpc\PublicGetGuests;

use Resrequest\API\PublicUser;
use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class PublicGetGuestsController extends AbstractActionController
{
	use PublicUser;

    public function __construct($em, $auth)
    {
        $this->em = $em;
        $this->auth = $auth;
    }

    public function publicGetGuestsAction()
    {
		$login = $this->publicUserGuestLogin();
		if($login !== true) {
			return $login;
		}

        $params = $this->bodyParams();
        $db = $this->em->getConnection();

		$rv_reservation_id = $params['reservation_id'];
		$email = $params['email'];

		$reservation = $db->fetchAssoc("
			SELECT
				rv_reservation.rv_reservation_ix AS reservation_id,
				rv_reservation.rv_res_name AS reservation_name,
				rv_reservation.rf_reservation_status_id AS status_id,
				rf_reservation_status.rf_reservation_status_desc AS status_name,
				rv_reservation.rv_provision_expiry_date AS status_prov_expiry,
				IF(pr_persona.pr_persona_ix IS NULL, '0', pr_persona.pr_persona_ix) AS agent_id,
				IF(pr_persona.pr_name_last IS NULL, 'Direct', pr_persona.pr_name_last) AS agent_name,
				rv_reservation.rv_agent_ref AS voucher
			FROM
				rv_reservation
				INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
			WHERE
				rv_reservation.rv_reservation_ix = ?
		",[$rv_reservation_id]);
		if($reservation === false) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}

		$items = $db->fetchAll("
			SELECT DISTINCT
				rv_reservation_item.rv_reservation_item_ix AS id,
				rv_reservation_item.pr_business_id AS property_id,
				pr_persona.pr_name_last AS property_name,
				rv_reservation_item.ac_accomm_type_id AS accomm_id,
				ac_accomm_type.ac_accomm_desc AS accomm_name,
				rv_reservation_item.rv_item_date_arrive AS 'from',
				rv_reservation_item.rv_item_date_depart AS 'to',
				rv_reservation_item.rv_item_accomm_count AS accomm_count,
				rv_reservation_item.rv_item_adult_count AS adult_count,
				rv_reservation_item.rv_item_child_count AS child_count,
				(rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) AS pax_count
			FROM
				rv_reservation_item
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
				INNER JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
				INNER JOIN pr_persona AS guest_persona ON guest_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
			WHERE
				rv_reservation_item.rv_reservation_id = ?
				AND guest_persona.pr_email = ?
			",[
				$rv_reservation_id,
				$email
			]);
		if($items === false) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}
		$reservation['items'] = $items;

		$guests = $db->fetchAll("
			SELECT DISTINCT
				rv_res_item_guest.pr_guest_id AS id,
				rv_reservation_item.rv_reservation_item_ix AS item_id,
				pr_persona.pr_name_first AS first_name,
				pr_persona.pr_name_last AS last_name,
				pr_persona.pr_email AS email
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_reservation_id = ?
				AND pr_persona.pr_email = ?
			ORDER BY
				rv_res_item_group.rv_res_item_group_ix
		",[
			$rv_reservation_id,
			$email
		]);
		if($guests === false) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}
		$reservation['guests'] = $guests;

		return new JsonModel($reservation);
    }
}
