<?php
namespace Resrequest\API\V1\Rpc\PublicGetReservation;

use Resrequest\API\PublicUser;
use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class PublicGetReservationController extends AbstractActionController
{
	use PublicUser;

    public function __construct($em, $auth)
    {
        $this->em = $em;
        $this->auth = $auth;
    }

    public function publicGetReservationAction()
    {
		$login = $this->publicUserContactLogin();
		if($login !== true) {
			return $login;
		}

        $params = $this->bodyParams();
        $db = $this->em->getConnection();

		$rv_reservation_id = $params['reservation_id'];

		$reservation = $db->fetchAssoc("
			SELECT
				rv_reservation.rv_reservation_ix AS reservation_id,
				rv_reservation.rv_res_name AS reservation_name,
				rv_reservation.rf_reservation_status_id AS status_id,
				rf_reservation_status.rf_reservation_status_desc AS status_name,
				rv_reservation.rv_provision_expiry_date AS status_prov_expiry,
				IF(pr_persona.pr_persona_ix IS NULL, '0', pr_persona.pr_persona_ix) AS agent_id,
				IF(pr_persona.pr_name_last IS NULL, 'Direct', pr_persona.pr_name_last) AS agent_name,
				rv_reservation.rv_agent_ref AS voucher,
				contact.pr_name_first AS contact_name_first,
				contact.pr_name_last AS contact_name_last
			FROM
				rv_reservation
				INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
				LEFT JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation.rv_agent_id
				LEFT JOIN pr_persona AS contact ON contact.pr_persona_ix = rv_reservation.rv_corr_persona_id
			WHERE
				rv_reservation.rv_reservation_ix = ?
		",[$rv_reservation_id]);
		if($reservation === false) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}

		$items = $db->fetchAll("
			SELECT
				rv_reservation_item.rv_reservation_item_ix AS id,
				rv_reservation_item.pr_business_id AS property_id,
				pr_persona.pr_name_last AS property_name,
				rv_reservation_item.ac_accomm_type_id AS accomm_id,
				ac_accomm_type.ac_accomm_desc AS accomm_name,
				rv_reservation_item.rv_item_date_arrive AS 'from',
				rv_reservation_item.rv_item_date_depart AS 'to',
				rv_reservation_item.rv_item_accomm_count AS accomm_count,
				rv_reservation_item.rv_item_adult_count AS adult_count,
				rv_reservation_item.rv_item_child_count AS child_count,
				(rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) AS pax_count
			FROM
				rv_reservation_item
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
				INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
			WHERE
				rv_reservation_item.rv_reservation_id = ?
		",[$rv_reservation_id]);
		if($items === false) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing reservation id or email address.")
			);
		}
		foreach ($items as &$item) {
			$guests = $db->fetchAll("
				SELECT DISTINCT
					rv_res_item_guest.pr_guest_id AS id,
					pr_persona.pr_name_first AS first_name,
					pr_persona.pr_name_last AS last_name,
					pr_persona.pr_email AS email,
					rv_res_item_group_ix AS group_id
				FROM
					rv_res_item_guest
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
					INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
					INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
				WHERE
					rv_reservation_item.rv_reservation_item_ix = ?
				ORDER BY
					rv_res_item_group.rv_res_item_group_ix
			",[
				$item['id']
			]);

			$groups = [];
			foreach ($guests as $guest) {
				if (!isset($groups[$guest['group_id']])) {
					$groups[$guest['group_id']] = [];
				}

				$groups[$guest['group_id']][] = $this->sanitizeGuest($guest);
			}

			$item['guests'] = array_values($groups);
		}
		$reservation['items'] = $items;

		$reservationGuests = $db->fetchAll("
			SELECT
				pr_persona.pr_name_first AS first_name,
				pr_persona.pr_name_last AS last_name,
				pr_persona.pr_persona_ix AS id,
				pr_persona.pr_email AS email
			FROM
				rv_reservation
				INNER JOIN rv_reservation_guest ON rv_reservation_guest.rv_reservation_id = rv_reservation.rv_reservation_ix
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_guest.pr_guest_id
				LEFT JOIN pr_guest ON pr_guest.pr_guest_id = pr_persona.pr_persona_ix
			WHERE
				rv_reservation.rv_reservation_ix = ?
				AND pr_persona.pr_sys_code <= 6
				AND pr_persona.pr_persona_inactive_yn = 0
			ORDER BY
				pr_persona.pr_name_first, pr_persona.pr_name_last
		",[
			$rv_reservation_id
		]);

		$allocatedGuests = $db->fetchAll("
			SELECT DISTINCT
				rv_res_item_guest.pr_guest_id AS id
			FROM
				rv_res_item_guest
				INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_res_item_guest.pr_guest_id
				INNER JOIN rv_res_item_group ON rv_res_item_group.rv_res_item_group_ix = rv_res_item_guest.rv_res_item_group_id
				INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
			WHERE
				rv_reservation_item.rv_reservation_id = ?
		",[
			$rv_reservation_id
		]);
		$allocatedGuests = array_flatten($allocatedGuests);

		if (!is_array($allocatedGuests)) {
			$allocatedGuests = [];
		}

		$unallocatedGuests = [];
		foreach($reservationGuests as $guest) {
			if (!in_array($guest['id'], $allocatedGuests)) {
				$unallocatedGuests[] = $this->sanitizeGuest($guest);
			}
		}

		$reservation['guests'] = $unallocatedGuests;

		return new JsonModel($reservation);
	}
	
	function sanitizeGuest($guest) {
		$guest['first_name'] = substr($guest['first_name'], 0, 3) . '****';
		$guest['last_name'] = substr($guest['last_name'], 0, 3) . '****';

		$emailParts = explode('@', $guest['email']);
		$emailUser = $emailParts[0];
		$emailDomain = "@" . $emailParts[1];
		$guest['email'] = substr($emailUser, 0, 3) . '****' . $emailDomain;

		return $guest;
	}
}
