<?php
namespace Resrequest\API\V1\Rpc\PublicSaveGuests;

use Resrequest\API\PublicUser;
use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

define('GUEST_LIST_SAVE_SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))))); //Go back 5 directories
define('GUEST_LIST_SAVE_ROOT', GUEST_LIST_SAVE_SERVER. '/Application/src/Resrequest/legacy');
define('REFERRING_URI', $_SERVER['REQUEST_URI']);
class PublicSaveGuestsController extends AbstractActionController
{
	use PublicUser;

	public function __construct($em, $auth)
	{
		$this->em = $em;
		$this->auth = $auth;
		$this->legacy = __DIR__."/../../../../../../../Application/src/Resrequest/legacy/";
	}

	public function publicSaveGuestsAction()
	{
		$login = $this->publicUserContactLogin();
		if($login !== true) {
			return $login;
		}

		$params = $this->bodyParams();
		$db = $this->em->getConnection();

		// Validate parameters
		if(!array_key_exists("items", $params)) {
			return new ApiProblemResponse(
				new ApiProblem(400, "Invalid payload missing items.")
			);
		}
		$items = $params['items'];
		if(!is_array($items) || sizeof($items) < 1) {
			return new ApiProblemResponse(
				new ApiProblem(400, "Invalid payload missing items.")
			);
		}

		$hasGuest = false;
		foreach($items as &$item) {
			if(!array_key_exists("id",$item)) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Invalid payload missing itinerary id.")
				);
			}
			$rv_reservation_item = $db->fetchAssoc("
				SELECT
					rv_reservation_item.rv_item_accomm_count AS accomm_count,
					(rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) AS pax_count
				FROM
					rv_reservation_item
				WHERE
					rv_reservation_item.rv_reservation_item_ix = ?
					AND rv_reservation_item.rv_reservation_id = ?
			",[
				$item['id'],
				$params['reservation_id']
			]);
			if($rv_reservation_item === false) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Unknown itinerary id.")
				);
			}
			if(!array_key_exists("rooms", $item) || !is_array($item['rooms']) || sizeof($item['rooms']) < 1) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Invalid payload missing rooms.")
				);
			}
			if(sizeof($item['rooms']) > $rv_reservation_item['accomm_count']) {
				return new ApiProblemResponse(
					new ApiProblem(400, "Too many rooms.")
				);
			}
			foreach($item['rooms'] as &$guests) {
				if(!is_array($guests)) {
					return new ApiProblemResponse(
						new ApiProblem(400, "Invalid payload missing guest list.")
					);
				}
				if(sizeof($guests) > $rv_reservation_item['pax_count']) {
					return new ApiProblemResponse(
						new ApiProblem(400, "Too many guests.")
					);
				}
				foreach($guests as &$guest) {
					if(!is_array($guest)) {
						return new ApiProblemResponse(
							new ApiProblem(400, "Invalid payload missing guest.")
						);
					}

					if (
						empty($guest['id'])
					) {
						// Validation for new guest entries
						if(!array_key_exists("first_name", $guest)) {
							$guest['first_name'] = "";
						}
						if(!array_key_exists("last_name", $guest)) {
							$guest['last_name'] = "";
						}
						if(trim($guest['first_name']) == "" && trim($guest['last_name']) == "") {
							return new ApiProblemResponse(
								new ApiProblem(400, "Invalid payload missing guest name.")
							);
						}
						if(!array_key_exists("email", $guest)) {
							return new ApiProblemResponse(
								new ApiProblem(400, "Invalid payload missing guest email.")
							);
						}
						if(!preg_match("/.+@.+\..+/",$guest['email'])) {
							return new ApiProblemResponse(
								new ApiProblem(400, "Invalid payload invalid guest email.")
							);
						}
					} elseif (!empty($guest['id']) && !empty($guest['updated'])) {
						// Validation for updated guest entries
						if(!array_key_exists("first_name", $guest)) {
							$guest['first_name'] = "";
						}
						if(!array_key_exists("last_name", $guest)) {
							$guest['last_name'] = "";
						}
						if(!array_key_exists("email", $guest)) {
							return new ApiProblemResponse(
								new ApiProblem(400, "Invalid payload missing guest email.")
							);
						}
						if(!empty($guest['email']) && !preg_match("/.+@.+\..+/",$guest['email'])) {
							return new ApiProblemResponse(
								new ApiProblem(400, "Invalid payload invalid guest email.")
							);
						}
					}
					$hasGuest = true;
				}
				unset($guest);
			}
			unset($guests);
		}
		unset($item);
		if(!$hasGuest) {
			return new ApiProblemResponse(
				new ApiProblem(400, "Invalid payload has no guests.")
			);
		}

		// Save guests
		require_once($this->legacy . "db.rv_res_item_group.php");
		require_once($this->legacy . "db.rv_res_item_guest.php");
		require_once($this->legacy . "db.rv_reservation_guest.php");
		require_once($this->legacy . "db.pr_persona.php");
		require_once($this->legacy . "db.pr_guest.php");
		require_once($this->legacy . "functions.reservation.php");

		$linkMap = [];
		foreach($items as $item) {
			// Unlink any existing guests
			$rv_res_item_group_ids = $db->executeQuery("
				SELECT
					rv_res_item_group.rv_res_item_group_ix
				FROM
					rv_res_item_group
				WHERE
					rv_res_item_group.rv_reservation_item_id = ?
			",[$item['id']])->fetchAll(\PDO::FETCH_COLUMN);
			foreach($rv_res_item_group_ids AS $rv_res_item_group_id) {
				db_rv_res_item_guest_delete_by_group($rv_res_item_group_id);
			}

			// Create and link new guests
			foreach($item['rooms'] as $guests) {
				$rv_res_item_group_id = array_shift($rv_res_item_group_ids);
				if(empty($rv_res_item_group_id)) { // Create a new group if needed
					$rv_res_item_group_id = db_rv_res_item_group_insert($item['id']);
				}
				foreach($guests as $guest) {
					$pr_guest_id = false;

					if (
						empty($guest['id']) &&
						($guest['link'] === false ||
							($guest['link'] !== false &&
								!isset($linkMap[$guest['link']])
							)
						)
					) {
						$pr_guest_id = db_pr_persona_insert(false,$guest['last_name'],$guest['first_name'],'','',$guest['email']);
						db_pr_guest_insert($pr_guest_id);
						db_rv_reservation_guest_insert($params['reservation_id'], $pr_guest_id);

						if ($guest['link'] !== false) {
							$linkMap[$guest['link']] = $pr_guest_id;
						}
					} else if ($guest['link'] !== false && isset($linkMap[$guest['link']]) && empty($guest['id'])) {
						$pr_guest_id = $linkMap[$guest['link']];
					} else {
						$pr_guest_id = $guest['id'];
						if (!empty($guest['updated'])) {
							$prPersona = db_pr_persona_select($pr_guest_id);

							$guest['first_name'] = empty($guest['first_name']) ? $prPersona['pr_name_first'] : $guest['first_name'];
							$guest['last_name'] = empty($guest['last_name']) ? $prPersona['pr_name_last'] : $guest['last_name'];
							$guest['email'] = empty($guest['email']) ? $prPersona['pr_email'] : $guest['email'];

							db_pr_persona_update($pr_guest_id,$guest['last_name'],$guest['first_name'],'','',$guest['email']);
						}
					}

					if ($pr_guest_id) {
						db_rv_res_item_guest_insert($pr_guest_id, $rv_res_item_group_id);
					}
				}
			}
		}

		ammendReservation($params['reservation_id'], "Public guest list update");

		$rf_res_office_id = $db->fetchAssoc("select rf_res_office_id from rf_default where rf_default_id = '1'")['rf_res_office_id'];
		$resOfficeContact = $db->fetchAssoc("
			SELECT
				pr_email,
				pr_phone_number
			FROM
				pr_persona
				INNER JOIN pr_phone ON pr_phone.pr_persona_id = pr_persona.pr_persona_ix
			WHERE pr_persona_ix = ?
		", [$rf_res_office_id]);

		$reservationDetails = $db->fetchAssoc("
			SELECT
				contact.pr_name_first AS contactNameFirst,
				contact.pr_name_last AS contactNameLast,
				contact_phone.pr_phone_number AS contactPhone,
				contact.pr_email as contactEmail,

				consultant.pr_name_first AS consultantNameFirst,
				consultant.pr_name_last AS consultantNameLast,
				consultant_phone.pr_phone_number AS consultantPhone,
				consultant.pr_email as consultantEmail
			FROM
				rv_reservation
				INNER JOIN pr_persona AS contact ON contact.pr_persona_ix = rv_reservation.rv_corr_persona_id
				LEFT JOIN pr_phone AS contact_phone ON contact_phone.pr_persona_id = contact.pr_persona_ix
				
				INNER JOIN pr_persona AS consultant ON consultant.pr_persona_ix = rv_reservation.rv_consultant_id
				LEFT JOIN pr_phone AS consultant_phone ON consultant_phone.pr_persona_id = consultant.pr_persona_ix
			WHERE
				rv_reservation.rv_reservation_ix = ?
		", [$params['reservation_id']]);

		$contactName = trim("{$reservationDetails['contactNameFirst']} {$reservationDetails['contactNameLast']}");
		$consultantName = trim("{$reservationDetails['consultantNameFirst']} {$reservationDetails['consultantNameLast']}");
		$data = [
			'rv_reservation_id' => $params['reservation_id'],
			'consultant_name' => $contactName,
			'consultant_email' => $reservationDetails['consultantEmail'],
			'contact_name' => $consultantName,
			'contact_email' => $reservationDetails['contactEmail'],
			'res_office_phone' => $resOfficeContact['pr_phone_number'],
			'res_office_email' => $resOfficeContact['pr_email'],
			'items' => [],
		];

		$emailItems = [];
		foreach ($items as $item) {
			$details = $db->fetchAssoc("
				SELECT
					rv_reservation_item.rv_item_accomm_count AS accomm_count,
					(rv_reservation_item.rv_item_adult_count + rv_reservation_item.rv_item_child_count) AS pax_count,
					rv_reservation_item.rv_item_date_arrive AS from_date,
					rv_reservation_item.rv_item_date_depart AS to_date,
					pr_persona.pr_name_last AS business_name,
					ac_accomm_type.ac_accomm_desc AS accomm_desc
				FROM
					rv_reservation_item
					INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
					INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
				WHERE
					rv_reservation_item.rv_reservation_item_ix = ?
					AND rv_reservation_item.rv_reservation_id = ?
			",[
				$item['id'],
				$params['reservation_id']
			]);

			$emailItems[] = [
				'id' => $item['id'],
				'accomm_count' => $details['accomm_count'],
				'pax_count' => $details['pax_count'],
				'from' => $details['from_date'],
				'to' => $details['to_date'],
				'business_name' => $details['business_name'],
				'accomm_desc' => $details['accomm_desc'],
				'rooms' => $item['rooms']
			];
		}

		$data['items'] = $emailItems;

		$this->sendEmail($data);

		return new JsonModel([
			'status'=>true
		]);
	}
	
	function sendEmail($data) {
		require_once(GUEST_LIST_SAVE_ROOT . '/class.mysqldb.php');
		require_once(GUEST_LIST_SAVE_ROOT . '/functions.mail.php');

		$message = $this->buildEmail($data);

		$failed = email(
			$data['res_office_email'],
			$data['contact_email'],
			"Guest list updated ({$GLOBALS['principal_name']})",
			'',
			$message['guest'],
			0,
			0,
			'',
			$GLOBALS['principal_name'],
			'',
			'',
			false,
			false,
			50,
			true
		);

		$failed = email(
			$data['res_office_email'],
			$data['consultant_email'],
			"Guest list updated ({$GLOBALS['principal_name']})",
			'',
			$message['consultant'],
			0,
			0,
			'',
			$GLOBALS['principal_name'],
			'',
			'',
			false,
			false,
			50,
			true
		);
	}

	private function buildEmail($data) {
		$itemTemplate = '
			<tr	>
				<td style="font-size:18px;padding-top:10px;margin-bottom:5px;font-weight:bold;">
					!from_date! - !to_date!
				</td>
			</tr>
			<tr>
				<td style="font-size:18px;margin-bottom:5px;">
					!business_name! - !accomm_count!x !accomm_desc! (!pax_count! pax)
				</td>
			</tr>
			!room_rows!';

		$roomTemplate = '
			<tr>
				<td style="margin-bottom:20px;">
					<table>
						!guest_rows!
					</table>
				</td>
			</tr>';

		$guestTemplate = '
			<tr>
				<td style="font-size: 14px; color: #444444;">
					<span>!name! <a style="cursor:pointer;color:#0000EE;" href="mailto:!email!">(!email!)</a></span>
				</td>
			</tr>';

		$rows = '';
		$itemRow = '';
		$roomRows = '';
		$guestRows = '';
		foreach ($data['items'] as $item) {
			$itemRow = $itemTemplate;
			$temp = [];

			$temp['accomm_count'] = $item['accomm_count'];
			$temp['pax_count'] = $item['pax_count'];
			$temp['from_date'] = (new \DateTime($item['from']))->format('d M Y');
			$temp['to_date'] = (new \DateTime($item['to']))->format('d M Y');
			$temp['business_name'] = $item['business_name'];
			$temp['accomm_desc'] = $item['accomm_desc'];

			$itemRow = $this->template($itemRow, $temp);

			foreach ($item['rooms'] as $room) {
				$roomRows .= $roomTemplate;
				foreach ($room as $guest) {
					$guestRows .= $guestTemplate;
					$guestName = trim("{$guest['first_name']} {$guest['last_name']}");
					$guestRows = str_replace("!name!", $guestName, $guestRows);
					$guestRows = str_replace("!email!", $guest['email'], $guestRows);
				}
				$roomRows = str_replace("!guest_rows!", $guestRows, $roomRows);
				$guestRows = '';
			}
			$rows .= str_replace("!room_rows!", $roomRows, $itemRow);
			$roomRows = '';
		}

		$temp = [];

		$temp['principal_id'] = $GLOBALS['principal_id'];
		$temp['Domain'] = $GLOBALS['http'] . $GLOBALS['domain']; 
		$temp['referrer'] = $GLOBALS['domain'] . '/guest'; 
		$temp['LogoSrc'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/" . $GLOBALS['principal_id'] . "/top_clientlogo.gif";
		$temp['guestAppImage'] = $GLOBALS['http'] . $GLOBALS['images_dir'] . "/" . $GLOBALS['principal_id'] . "/guest-app_email.jpg";

		$temp['reservation_id'] = $data['rv_reservation_id'];
		$temp['principal_name'] = $GLOBALS['principal_name'];
		$temp['consultant_name'] = $data['consultant_name'];
		$temp['consultant_email'] = $data['consultant_email'];
		$temp['res_office_phone'] = $data['res_office_phone'];
		$temp['res_office_email'] = $data['res_office_email'];
		$temp['rows'] = $rows;

		$templateGuest = file_get_contents(GUEST_LIST_SAVE_SERVER . '/Application/public/html/template_guest_list_update.htm');
		foreach ($temp as $key => $value){
			$templateGuest = str_replace("!$key!", $value, $templateGuest);
		}
		$templateConsultant = file_get_contents(GUEST_LIST_SAVE_SERVER . '/Application/public/html/template_guest_list_update_consultant.htm');
		foreach ($temp as $key => $value){
			$templateConsultant = str_replace("!$key!", $value, $templateConsultant);
		}

		return array(
			'guest' => $templateGuest,
			'consultant' => $templateConsultant
		);
	}

	public function template($template, $data) {
		foreach ($data as $key => $value){
			$template = str_replace("!$key!", $value, $template);
		}

		return $template;
	}
}
