<?php
namespace Resrequest\API\V1\Rpc\ReminderGetUserEmail;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class ReminderGetUserEmailController extends AbstractActionController
{
    protected $em;
    private $data, $username, $db;

    public function __construct($em){
        $this->em = $em;
        $this->username = false;
        $this->data = [];
        $this->db = $this->em->getConnection();
    }

    public function reminderGetUserEmailAction()
    {
        $params = $this->bodyParams();


        if(!isset($params['query'])) {
            $this->response(['error' => 'Please provide a query parameter.']);
        }

        $escQuery = $this->db->quote("%{$params['query']}%");

        $results = $this->db->fetchAll("
            SELECT 
              pr_persona.pr_email,
              pr_persona.pr_persona_ix,
              pr_persona.pr_name_first,
              pr_persona.pr_name_last
            FROM 
              pr_persona
            WHERE 
              pr_persona.pr_persona_inactive_yn = 0 AND
              (
                pr_persona.pr_email IS NOT NULL AND
                pr_persona.pr_email <> ''
              )
              AND
              (
                pr_persona.pr_email LIKE {$escQuery} OR
                pr_persona.pr_name_first LIKE {$escQuery} OR
                pr_persona.pr_name_last LIKE {$escQuery}
              )
        ");

        foreach($results as $item) {
            $name = ($item['pr_name_first'] != "") ? $item['pr_name_first'] . " " : "";
            $this->data[] = [
                'id' => $item['pr_persona_ix'],
                'text' => $name.$item['pr_name_last']." - ". $item['pr_email'],
            ];
        }

        return $this->response(['results' => $this->data]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
