<?php
namespace Resrequest\API\V1\Rpc\RemindersAddReminder;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use DateTime;
use DateTimeZone;

use Resrequest\Application\Reminder\Reminder;
use Resrequest\DB\Enterprise\Entity\ReReminder;

require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/inc.setup.php');
require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/class.audit.php');

class RemindersAddReminderController extends AbstractActionController
{
    protected $em;
    private $data, $params, $db, $username, $message, $lastIdSql, $status;
    private $PrPersona, $RvReservation;
    private $dbService;

    public function __construct($em, $dbService) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->data = [];
        $this->params = null;
        $this->username = null;
        $this->message = "";
        $this->lastIdSql = "SELECT @last_insert_id;";
        $this->status = "error";
        $this->RvReservation = '\Resrequest\DB\Enterprise\Entity\RvReservation';
        $this->PrPersona = '\Resrequest\DB\Enterprise\Entity\PrPersona';
        $this->dbService = $dbService;
    }

    public function remindersAddReminderAction()
    {
        $this->params = $this->bodyParams();

        $reRepeatYn = (isset( $this->params['reRepeatYn'])) ?  $this->params['reRepeatYn'] : 0;

        if(!isset($this->params['reNote']) || $this->params['reNote'] == "") {
            return $this->response(["status" => "error", "message" => "Please fill in reminder note."]);
        }

        if(!isset($this->params['reReferToId']) || $this->params['reReferToId'] == "") {
            return ["status" => "error", "message" => "Please fill in reminder reference object"];
        }

        if(!isset($this->params['reSendDate']) || $this->params['reSendDate'] == "") {
            return ["status" => "error", "message" => "Please fill in reminder send date."];
        }
        else {
            $sendDateTz = isset($this->params['reSendDateTz']) && !empty($this->params['reSendDateTz']) ? $this->params['reSendDateTz'] : date_default_timezone_get();
            $sendDate = new DateTime($this->params['reSendDate'], new DateTimeZone($sendDateTz));
            $now = new DateTime(date("Y-m-d H:i:s"));
            if($reRepeatYn == 0 && $sendDate < $now) {
                return $this->response(["status" => "error", "message" => "The date and time selected to send the reminder has already elapsed."]);
            }
        }

        if((!isset($this->params['rePersonaId']) || $this->params['rePersonaId'] == "") && (!isset($this->params['reIncludeMe']) || $this->params['reIncludeMe'] == "")) {
            return $this->response(["status" => "error", "message" => "Please select at least 1 recipient for the reminder."]);
        }
        else {
            $this->params['rePersonaId'] = ($this->params['reIncludeMe'] == '1') ? $this->params['rePersonaId'].",".$_SESSION['userid'] : $this->params['rePersonaId'];
        }

        if($this->params['rePersonaId'] == "") {
            return $this->response(["status" => "error", "message" => "Please select at least 1 recipient for the reminder."]);
        }

        $reReferTo = explode("|", $this->params['reReferToId']);


        $prUserId = isset($_SESSION['userid']) ? $_SESSION['userid'] : null;
        $createdTz = date("e");

        if($reReferTo[0] == ReReminder::RE_REMINDER_LINK_TO_RV_RESERVATION) {
            if(!$this->em->find($this->RvReservation, $reReferTo[1])) {
                return $this->response(['status' => $this->status, 'message' => 'Invalid reservation selected'] );
            }
        }
        elseif($reReferTo[0] == ReReminder::RE_REMINDER_LINK_TO_PR_PERSONA) {
            if(!$this->em->find($this->PrPersona, $reReferTo[1])) {
                return $this->response(['status' => $this->status, 'message' => 'Invalid contact selected'] );
            }
        }
        else return $this->response(['status' => $this->status, 'message' => 'Please select a valid reference'] );

        $host = $_SERVER['SERVER_NAME'];
        $reminder = new Reminder($this->dbService, $host, $GLOBALS['dbName']);
        $rePersonaIds = explode(',', $this->params['rePersonaId']);
        $rePersonaIds = array_unique($rePersonaIds);
        $response = $reminder->create(
          $this->params['reNote'],
          $reRepeatYn,
          ReReminder::RE_REMINDER_STATUS_ACTIVE,
          $this->params['reSendDate'],
          $this->params['reSendDateTz'],
          $reReferTo[0],
          $reReferTo[1],
          $prUserId,
          $rePersonaIds
        );

        return $response;
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
