<?php
namespace Resrequest\API\V1\Rpc\RemindersCountReminder;

use Resrequest\DB\Enterprise\Entity\ReReminder;
use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

class RemindersCountReminderController extends AbstractActionController
{
    protected $em;
    private $data, $params, $db, $message, $status;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->data = [];
        $this->params = null;
        $this->message = "";
        $this->status = "error";
    }

    public function remindersCountReminderAction() {

        $this->params = $this->bodyParams();

        if(!isset($this->params['reReminderReferenceTypeInd']) || $this->params['reReminderReferenceTypeInd'] == "") {
            return new JsonModel(["status" => $this->status, "message" => "Invalid reference type indicator."]);
        }

        if(!isset($this->params['reReminderReferenceId']) || $this->params['reReminderReferenceId'] == "") {
            return new JsonModel(["status" => $this->status, "message" => "Invalid reference id."]);
        }


        $count = $this->db->fetchColumn("
                    SELECT 
                        COUNT(*) AS counter 
                    FROM 
                        re_reminder 
                    WHERE 
                        re_reminder_link_to_ind_id = ? AND 
                        re_reminder_link_to_id = ?
                  ",
                [$this->params['reReminderReferenceTypeInd'], $this->params['reReminderReferenceId']]);

        if($count > 0 ) {
            $this->status = "success";

            if ($this->params['reReminderReferenceTypeInd'] == ReReminder::RE_REMINDER_LINK_TO_RV_RESERVATION) {
                $this->message = "The reservation has reminder(s)";
            }
            elseif ($this->params['reReminderReferenceTypeInd'] == ReReminder::RE_REMINDER_LINK_TO_PR_PERSONA) {
                $this->message = "The contact has reminder(s)";
            }
            else {
                $this->message = "";
            }
        }
        else {
            $this->status = "error";
            $this->message = "Item does not have reminder(s)";
        }

        return $this->response(["status" => $this->status, "message" => $this->message,]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
