<?php
namespace Resrequest\API\V1\Rpc\RemindersDeleteReminder;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

use Resrequest\DB\Enterprise\Entity\ReReminder;

require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/inc.setup.php');
require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/class.audit.php');

class RemindersDeleteReminderController extends AbstractActionController
{
    protected $em;
    private $data, $params, $db, $username, $message, $status;
    private $ReReminder, $ReReminderPersona;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->data = [];
        $this->params = null;
        $this->username = null;
        $this->message = "Reminder could not be deleted.";
        $this->status = "error";
        $this->ReReminder = '\Resrequest\DB\Enterprise\Entity\ReReminder';
        $this->ReReminderPersona = '\Resrequest\DB\Enterprise\Entity\ReReminderPersona';
    }

    public function remindersDeleteReminderAction() {

        $this->params = $this->bodyParams();

        if(!isset($this->params['reReminderId']) || $this->params['reReminderId'] == "") {
            return $this->response(["status" => "error", "message" => "Invalid reminder."]);
        }

        $ReReminder = $this->em->find($this->ReReminder, $this->params['reReminderId']);
        $reReferTo = $ReReminder->getReReminderLinkToIndId();
        $entityId = $ReReminder->getReReminderLinkToId();
        $this->em->remove($ReReminder);

        $entityType = null;
        if($reReferTo == ReReminder::RE_REMINDER_LINK_TO_RV_RESERVATION) {
            $entityType = \AuditTrail::TYPE_RESERVATION;
        }
        elseif($reReferTo == ReReminder::RE_REMINDER_LINK_TO_PR_PERSONA) {
            $entityType = \AuditTrail::TYPE_PERSONA;
        }
        global $lDB;
        $audit = new \AuditTrail($entityId,$entityType,[],$lDB);
        $audit->save("Reminder (Delete)");

        if($ReReminder){
            $ReReminderPersonas = $this->em->getRepository($this->ReReminderPersona)->findBy(['reReminderId' => $this->params['reReminderId']]);
            foreach ($ReReminderPersonas as $ReReminderPersona) {
                $this->em->remove($ReReminderPersona);
            }

            $this->message = "Reminder successfully deleted.";
            $this->status = "success";
        }

        $this->em->flush();

        return $this->response(["message" => $this->message, "status" => $this->status]);
    }

    private function response($data, $status = 1) {
        return new JsonModel($data);
    }
}
