<?php
namespace Resrequest\API\V1\Rpc\RemindersEditReminder;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use DateTime;
use DateTimeZone;

use Resrequest\DB\Enterprise\Entity\ReReminder;
use Resrequest\DB\Enterprise\Entity\ReReminderPersona;

require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/inc.setup.php');
require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/class.audit.php');

class RemindersEditReminderController extends AbstractActionController
{
    protected $em;
    private $data, $params, $db, $username, $message, $status;
    private $PrPersona, $RvReservation, $ReReminder, $ReReminderPersona;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->data = [];
        $this->params = null;
        $this->username = null;
        $this->message = "";
        $this->status = "error";
        $this->ReReminder = '\Resrequest\DB\Enterprise\Entity\ReReminder';
        $this->ReReminderPersona = '\Resrequest\DB\Enterprise\Entity\ReReminderPersona';
        $this->RvReservation = '\Resrequest\DB\Enterprise\Entity\RvReservation';
        $this->PrPersona = '\Resrequest\DB\Enterprise\Entity\PrPersona';
    }

    public function remindersEditReminderAction()
    {
        $this->params = $this->bodyParams();

        $reRepeatYn = (isset( $this->params['reRepeatYn'])) ?  $this->params['reRepeatYn'] : 0;

        if(!isset($this->params['reNote']) || $this->params['reNote'] == "") {
            return $this->response(["status" => "error", "message" => "Please fill in reminder note."]);
        }

        if(!isset($this->params['reReferToId']) || $this->params['reReferToId'] == "") {
            return ["status" => "error", "message" => "Please fill in reminder reference object"];
        }

        if(!isset($this->params['reSendDate']) || $this->params['reSendDate'] == "") {
            return ["status" => "error", "message" => "Please fill in reminder send date."];
        }
        else {
            $sendDateTz = isset($this->params['reSendDateTz']) && !empty($this->params['reSendDateTz']) ? $this->params['reSendDateTz'] : date_default_timezone_get();
            $sendDate = new DateTime($this->params['reSendDate'], new DateTimeZone($sendDateTz));
            $now = new DateTime(date("Y-m-d H:i:s"));
            if($reRepeatYn == 0 && $sendDate < $now) {
                return $this->response(["status" => "error", "message" => "The date and time selected to send the reminder has already elapsed."]);
            }
        }

        if((!isset($this->params['rePersonaId']) || $this->params['rePersonaId'] == "") && (!isset($this->params['reIncludeMe']) || $this->params['reIncludeMe'] == "")) {
            return $this->response(["status" => "error", "message" => "Please select at least 1 recipient for the reminder."]);
        }
        else {
            $this->params['rePersonaId'] = ($this->params['reIncludeMe'] == '1') ? $this->params['rePersonaId'].",".$_SESSION['userid'] : $this->params['rePersonaId'];
        }

        if($this->params['rePersonaId'] == "") {
            return $this->response(["status" => "error", "message" => "Please select at least 1 recipient for the reminder."]);
        }

        $reReferTo = explode("|", $this->params['reReferToId']);
        $prUserId = isset($_SESSION['userid']) ? $_SESSION['userid'] : null;
        $createdTz = date("e");

        if($reReferTo[0] == ReReminder::RE_REMINDER_LINK_TO_RV_RESERVATION) {
            if(!$this->em->find($this->RvReservation, $reReferTo[1])) {
                return $this->response(['status' => $this->status, 'message' => 'Invalid reservation id selected'] );
            }
        }
        elseif($reReferTo[0] == ReReminder::RE_REMINDER_LINK_TO_PR_PERSONA) {
            if(!$this->em->find($this->PrPersona, $reReferTo[1])) {
                return $this->response(['status' => $this->status, 'message' => 'Invalid contact id selected'] );
            }
        }
        else {
            return $this->response(['status' => $this->status, 'message' => 'Please select a valid reference'] );
        }

        try {
            $ReReminder = $this->em->find($this->ReReminder, $this->params['reReminderId']);

            if(!isset($ReReminder)) {
                return $this->response(["status" => "error", "message" => "The reminder could not be found"]);
            }

            $ReReminder->setReReminderNote($this->params['reNote'])
                ->setReReminderRepeatYn($reRepeatYn)
                ->setReReminderStatusId($ReReminder::RE_REMINDER_STATUS_ACTIVE)
                ->setReReminderSendDate($this->params['reSendDate'])
                ->setReReminderSendDateTz($this->params['reSendDateTz'])
                ->setReReminderLinkToIndId($reReferTo[0])
                ->setReReminderLinkToId($reReferTo[1])
                ->setAdModifyUserId($prUserId)
                ->setAdModifyDateTz($createdTz);

            $this->em->persist($ReReminder);
            $this->em->flush();

            //Delete all personas
            $query = "DELETE FROM re_reminder_persona WHERE re_reminder_persona.re_reminder_id = :reReminderId";
            $queryParameter = ['reReminderId' => $this->params['reReminderId']];
            $deleteStatement = $this->db->prepare($query);
            $deleteStatement->execute($queryParameter);

            //Re-Insert Ids
            $ids = explode(',', $this->params['rePersonaId']);
            $ids = array_unique($ids);
            foreach ($ids as $id) {
                if ($objPrPersona = $this->em->find($this->PrPersona, $id)) {
                    $ReReminderPersona = new ReReminderPersona();
                    $ReReminderPersona->setReReminderSentToEmail($objPrPersona->getPrEmail());
                    $ReReminderPersona->setReReminderId($this->params['reReminderId']);
                    $ReReminderPersona->setPrPersonaId($id);
                    $this->em->persist($ReReminderPersona);
                }
            }
            $this->em->flush();
            $entityType = null;
            if($reReferTo[0] == ReReminder::RE_REMINDER_LINK_TO_RV_RESERVATION) {
                $entityType = \AuditTrail::TYPE_RESERVATION;
            }
            elseif($reReferTo[0] == ReReminder::RE_REMINDER_LINK_TO_PR_PERSONA) {
                $entityType = \AuditTrail::TYPE_PERSONA;
            }
            global $lDB;
            $audit = new \AuditTrail($reReferTo[1],$entityType,[],$lDB);
            $audit->save("Reminder (Edit)");
        }
        catch (\Exception $e) {
            return $this->response(['status' => 'error', 'message' => 'An error occurred while updating the reminder.']);
        }


        return $this->response(["message" => "Reminder successfully updated.", "status" => "success"]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
