<?php
namespace Resrequest\API\V1\Rpc\RemindersGetReferTo;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

class RemindersGetReferToController extends AbstractActionController
{
    protected $em;
    private $prData, $rvData, $params, $db;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->rvData = [];
        $this->prData = [];
        $this->params = null;
    }

    public function remindersGetReferToAction() {

        $this->params = $this->bodyParams();

        $escQuery = $this->db->quote("%{$this->params['query']}%");

        $reservationResults = $this->db->fetchAll("
            SELECT 
              rv_reservation.rv_reservation_ix,
              rv_reservation.rv_res_name
            FROM 
              rv_reservation
            WHERE 
              rv_reservation.rv_deleted_yn = 0 AND
              (
                rv_reservation.rv_reservation_ix LIKE {$escQuery} OR 
                rv_reservation.rv_res_name LIKE {$escQuery}
              )
        ");

        foreach($reservationResults as $item) {
            $this->rvData [] = [
                'id' => "1|".$item['rv_reservation_ix'],
                'text' => $item['rv_reservation_ix']." - ". $item['rv_res_name'],
            ];
        }

        $contactResults = $this->db->fetchAll("
            SELECT
                 pr_persona.pr_email,
                 pr_persona.pr_persona_ix,
                 pr_persona.pr_name_first,
                 pr_persona.pr_name_last
            FROM
                 pr_persona
            WHERE
                pr_persona.pr_persona_inactive_yn = 0 AND
                (
                  pr_persona.pr_persona_ix LIKE {$escQuery} OR
                  pr_persona.pr_email LIKE  {$escQuery} OR
                  pr_persona.pr_name_first LIKE {$escQuery} OR
                  pr_persona.pr_name_last LIKE {$escQuery}
                )
        ");

        foreach($contactResults as $item) {
            $name = ($item['pr_name_first'] != "") ? $item['pr_name_first'] . " " : "";
            $email = ($item['pr_email'] != "") ? " - {$item['pr_email']}" : "";

            $this->prData [] = [
                'id' => "2|".$item['pr_persona_ix'],
                'text' => $name.$item['pr_name_last'].$email,
            ];
        }


        return $this->response([ "results" => [ [ "text" => "Reservations", "children" => $this->rvData], [ "text" => "Contacts", "children" => $this->prData] ]]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
