<?php
namespace Resrequest\API\V1\Rpc\RemindersGetReminder;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

use Resrequest\Application\Reminder\Reminder;

class RemindersGetReminderController extends AbstractActionController
{
  protected $em;
  private $db, $params, $status, $message, $data, $host;

  public function __construct($em, $enterprise) {
    $this->em = $em;
    $this->db = $this->em->getConnection();
    $this->params = null;
    $this->status = "error";
    $this->message = "Invalid reminder.";
    $this->data = [];
    $this->host = $enterprise->config['shortName'].".resrequest.com";
  }

  public function remindersGetReminderAction()
  {
    $this->params = $this->bodyParams();

    if(!isset($this->params['reReminderId']) || $this->params['reReminderId'] == "") {
      return new JsonModel(["status" => $this->status, "message" => $this->message]);
    }

    $reReminder = $this->db->fetchAssoc("
     SELECT 
          re_reminder.re_reminder_ix,
          re_reminder.re_reminder_note,
          re_reminder.re_reminder_send_date,
          re_reminder.re_reminder_repeat_yn,
          re_reminder.re_reminder_link_to_ind_id,
          re_reminder.re_reminder_link_to_id
        FROM  
          re_reminder
        WHERE 
          re_reminder.re_reminder_ix = ?
   ",[$this->params['reReminderId']]);

    $recipientsArr = $this->db->fetchAll("
        SELECT 
          re_reminder_persona.re_reminder_id,
          pr_persona.pr_persona_ix,
          pr_persona.pr_name_first,
          pr_persona.pr_name_last,
          pr_persona.pr_email
        FROM  
          re_reminder_persona
          INNER JOIN pr_persona ON pr_persona.pr_persona_ix = re_reminder_persona.pr_persona_id
        WHERE
          re_reminder_persona.re_reminder_id = ?
    ", [$this->params['reReminderId']]);

    $recipientIdStr = $recipientNameStr = $ccMe = "";
    foreach ($recipientsArr as $item){
      $recipientIdStr .= $item['pr_persona_ix'].', ';
      $recipientNameStr .= $item['pr_name_first'].' '.$item['pr_name_last'].' - '.$item['pr_email'].'| ';
      if(isset($_SESSION['userid']) && $item['pr_persona_ix'] == $_SESSION['userid']){
        $ccMe = 1;
      }
    }

    $recipientIdStr = ($recipientIdStr != "") ? rtrim( $recipientIdStr, ", ") : "";
    $recipientNameStr = ($recipientNameStr != "") ? rtrim( $recipientNameStr, "| ") : "";

    $this->data = [
      'ReReminderNote' => $reReminder['re_reminder_note'],
      'ReReminderRepeat' => $reReminder['re_reminder_repeat_yn'],
      'ReReminderSendDate' => date("m/d/Y H:i", strtotime($reReminder['re_reminder_send_date'])),
      'ReReminderReferToId' => $reReminder['re_reminder_link_to_ind_id'].'|'.$reReminder['re_reminder_link_to_id'],
      'ReReminderRecipientListId' => $recipientIdStr,
      'ReReminderRecipientListName' => $recipientNameStr,
      'ReReminderRecipientCCMe' => $ccMe
    ];

    return $this->response(["status" => $this->status, "message" => $this->message, "data" => $this->data]);
  }

  private function response($data)
  {
    return new JsonModel($data);
  }
}
