<?php
namespace Resrequest\API\V1\Rpc\RemindersReport;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use Resrequest\DB\Enterprise\Entity\ReReminder;
use Resrequest\DB\Enterprise\Entity\ReReminderPersona;

class RemindersReportController extends AbstractActionController
{
    protected $em;
    private $db, $params, $status, $message, $data;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->params = null;
        $this->status = "error";
        $this->message = "";
        $this->data = [];
    }

    public function remindersReportAction() {
        $addQuoteFunc = function ($string) {
            return "'{$string}'";
        };

        $this->params = $this->bodyParams();

        $fromDate = $this->params['reReminderFromDate'];
        $toDate = $this->params['reReminderToDate'];
        $this->sortDate($fromDate, $toDate);

        $linkToIdQuery = "";
        if(isset($this->params['reReminderLinkToId']) && count($this->params['reReminderLinkToId']) > 0) {
            $linkToIdQuery = " AND re_reminder.re_reminder_link_to_id IN (". implode(",", array_map($addQuoteFunc, $this->params['reReminderLinkToId'])) .")";
        }

        $linkToIndQuery = "";
        if(isset($this->params['reReminderLinkToInd']) && count($this->params['reReminderLinkToInd']) > 0) {
            $linkToIndQuery = " AND re_reminder.re_reminder_link_to_ind_id IN (". implode(',', array_map($addQuoteFunc, $this->params['reReminderLinkToInd'])) .")";
        }

        $envQuery = "";
        if(isset($this->params['reReminderEnv']) && count($this->params['reReminderEnv']) > 0) {
            $envQuery = " AND re_reminder.re_reminder_db IN (". implode(',', array_map($addQuoteFunc, $this->params['reReminderEnv'])) .")";
        }

        $personaIdQuery = "";
        if(isset($this->params['reReminderPersonaId']) && count($this->params['reReminderPersonaId']) > 0) {
            $reReminderPersonaId = implode(',', array_map($addQuoteFunc, $this->params['reReminderPersonaId']));
            $personaIdQuery = " AND ( re_reminder.ad_create_user_id IN ({$reReminderPersonaId}) OR re_reminder_persona.pr_persona_id IN ({$reReminderPersonaId})";
        }

        $statusIdQuery = "";
        if(isset($this->params['reReminderStatusId']) && count($this->params['reReminderStatusId']) > 0) {
            $reReminderStatusId = implode(',', array_map($addQuoteFunc, $this->params['reReminderStatusId']));
            $statusIdQuery = " AND re_reminder.re_reminder_status_id IN ({$reReminderStatusId})";
        }

        $query = "
             SELECT 
                DISTINCT(re_reminder.re_reminder_ix)
            FROM      
                re_reminder
                LEFT JOIN re_reminder_log ON re_reminder.re_reminder_ix = re_reminder_log.re_reminder_id
                LEFT JOIN re_reminder_persona ON re_reminder.re_reminder_ix = re_reminder_persona.re_reminder_id
            WHERE 
                1
                AND ( ( DATE(re_reminder.ad_create_date) BETWEEN '{$fromDate}' AND '{$toDate}')  OR ( DATE(re_reminder.re_reminder_send_date) BETWEEN '{$fromDate}' AND '{$toDate}')  )
                {$linkToIdQuery}
                {$linkToIndQuery}
                {$envQuery}
                {$personaIdQuery}
                {$statusIdQuery}
            ORDER BY
                re_reminder.re_reminder_repeat_yn DESC, re_reminder.re_reminder_send_date ASC
            ";
       $reReminderIxs = $this->db->fetchAll($query);

        foreach ($reReminderIxs as $reReminder) {
            $this->data[] = [
                'info' => $this->getReminderInfo($reReminder['re_reminder_ix']),
                'recipients' => $this->getReminderRecipients($reReminder['re_reminder_ix'])
            ];
        }

        return $this->response($this->data);
    }


    private function getReminderInfo($reReminderIx) {

        return $this->db->fetchAssoc("
            SELECT
                re_reminder.re_reminder_db,
                re_reminder.re_reminder_ix,
                re_reminder.re_reminder_note,
                re_reminder.re_reminder_status_id,
                re_reminder.re_reminder_send_date,
                re_reminder.re_reminder_send_date_tz,
                re_reminder.re_reminder_repeat_yn,
                re_reminder.re_reminder_link_to_ind_id,
                re_reminder.re_reminder_link_to_id,
                re_reminder.ad_create_date,
                re_reminder.ad_create_date_tz,
                re_reminder.ad_create_user_id,
                re_reminder.re_reminder_trf_yn
            FROM
                re_reminder
            WHERE
                re_reminder.re_reminder_ix = ? ",
            [$reReminderIx]);
    }

    private function getReminderRecipients($reReminderIx) {

        return $this->db->fetchAll("
            SELECT 
                pr_persona.pr_persona_ix,
                pr_persona.pr_name_first,
                pr_persona.pr_name_last,
                pr_persona.pr_email
            FROM  
                re_reminder_persona
                INNER JOIN pr_persona ON pr_persona.pr_persona_ix = re_reminder_persona.pr_persona_id
            WHERE
                re_reminder_persona.re_reminder_id = ?",
                [$reReminderIx]);
    }

    private function sortDate(&$from, &$to) {
        $from = strtotime($from);
        $to = strtotime($to);

        //Check for the greatest date
        if($from > $to){
            $t_fr = $from;
            $from = $to;
            $to   = $t_fr;
        }

        //Set date back to Y-m-d format
        $from = date("Y-m-d", $from);
        $to = date("Y-m-d", $to);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
