<?php
namespace Resrequest\API\V1\Rpc\RemindersSendReminders;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use Resrequest\DB\Enterprise\Entity\ReReminder;
use Resrequest\DB\Enterprise\Entity\ReReminderLog;
use Resrequest\Application\Reminder\Reminder;
define('SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))))); //Go back 5 directories
define('ROOT', SERVER. '/Application/src/Resrequest/legacy');
require_once(ROOT . '/class.form.php');
require_once(ROOT . '/class.mysqldb.php');
require_once(ROOT . '/class.mysqlfield.php');
require_once(ROOT . '/class.mysqltable.php');
require_once(ROOT . '/functions.template.php');
require_once(ROOT . '/functions.cache.php');
require_once(ROOT . '/functions.system.php');
require_once(ROOT . '/functions.php');
require_once(ROOT . '/functions.reservation.php');
require_once(ROOT . '/inc.setup.php');
require_once(ROOT . '/ac_logon.php');
require_once(ROOT . '/inc.globalarrays.php');
require_once(ROOT . '/functions.mail.php');
require_once(ROOT . '/class.audit.php');

class RemindersSendRemindersController extends AbstractActionController
{
    protected $em;
    private $db, $params, $host, $protocol, $content, $ReReminder, $PrPersona, $now;
    private $dbService;

    public function __construct($em, $dbService) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->params = null;
        $this->data = $this->content = [];
        $this->protocol = stripos($_SERVER['SERVER_PROTOCOL'],'https') === true ? 'https://' : 'http://';
        $this->host = $_SERVER["HTTP_HOST"]."/reservation.php?";
        $this->ReReminder = '\Resrequest\DB\Enterprise\Entity\ReReminder';
        $this->PrPersona = '\Resrequest\DB\Enterprise\Entity\PrPersona';
        $this->now = strtotime(date("Y-m-d H:i:s"));
        $this->dbService = $dbService;
    }

    public function remindersSendRemindersAction() {
        $this->params = $this->bodyParams();

        if(!isset($this->params['securityHash']) || $this->params['securityHash'] !== ReReminder::HASH_STRING){
            return $this->response(['data' => '', 'error' => 'Invalid security token', 'code' => 500]);
        }

        $host = $_SERVER['SERVER_NAME'];
        $reminder = new Reminder($this->dbService, $host, $GLOBALS['dbName']);
        return $reminder->send();
    }
}
