<?php
namespace Resrequest\API\V1\Rpc\RemindersStopReminders;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use DateTime;
use Resrequest\DB\Enterprise\Entity\ReReminder;

require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/inc.setup.php');
require_once(__DIR__ . '/../../../../../../../Application/src/Resrequest/legacy/class.audit.php');

class RemindersStopRemindersController extends AbstractActionController
{
    protected $em;
    private $params, $db, $ReReminder, $message, $status;

    public function __construct($em) {
        $this->em = $em;
        $this->db = $this->em->getConnection();
        $this->params = null;
        $this->message = "";
        $this->status = "error";
        $this->ReReminder = '\Resrequest\DB\Enterprise\Entity\ReReminder';
    }

    public function remindersStopRemindersAction()
    {
        $this->params = $this->bodyParams();

        $prUserId = isset($_SESSION['userid']) ? $_SESSION['userid'] : null;
        $now = date("Y-m-d H:i:s");
        $adModifyDateTz = date("e");

        try {
            $ReReminder = $this->em->find($this->ReReminder, $this->params['reReminderId']);

            if(!isset($ReReminder)) {
                return $this->response(["status" => "error", "message" => "The reminder could not be found"]);
            }

            $reReferTo = $ReReminder->getReReminderLinkToIndId();
            $entityId = $ReReminder->getReReminderLinkToId();

            $query = "
                UPDATE 
                    re_reminder 
                SET 
                    re_reminder_status_id = '40',
                    ad_modify_date = :modifyDate,
                    ad_modify_date_tz = :modifyTz,
                    ad_modify_user_id = :currentUser
                WHERE 
                    re_reminder.re_reminder_ix = :reReminderId";
            $queryParameter = [
                'reReminderId' => $this->params['reReminderId'],
                'modifyDate' => $now,
                'modifyTz' => $adModifyDateTz,
                'currentUser' => $prUserId,
            ];
            $stopStatement = $this->db->prepare($query);
            $stopStatement->execute($queryParameter);

            $entityType = null;
            if($reReferTo == ReReminder::RE_REMINDER_LINK_TO_RV_RESERVATION) {
                $entityType = \AuditTrail::TYPE_RESERVATION;
            }
            elseif($reReferTo == ReReminder::RE_REMINDER_LINK_TO_PR_PERSONA) {
                $entityType = \AuditTrail::TYPE_PERSONA;
            }
            global $lDB;
            $audit = new \AuditTrail($entityId,$entityType,[],$lDB);
            $audit->save("ReReminder (Stop)");

        }
        catch (\Exception $e) {
            return $this->response(['status' => 'error', 'message' => 'An error occurred while stopping the reminder.']);
        }

        return $this->response(["message" => "Reminder successfully stopped.", "status" => "success"]);
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
