<?php
namespace Resrequest\API\V1\Rpc\ResVegaGetAccess;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

class ResVegaGetAccessController extends AbstractActionController
{
    private $em;
    private $chartContainerService;
    private $auth;

    public function __construct($em, $chartContainerService, $auth) {
        $this->em = $em;
        $this->chartContainerService = $chartContainerService;
        $this->auth = $auth;
    }

    public function resVegaGetAccessAction()
    {
        $username = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
            $this->auth->setupContext($this->auth->getUserByName($username));
        }

        $allowed = false;
        if (!empty($GLOBALS['pr_business_link'])) {
            $allowed = true;
        }

        $resvegaContainers = \Resrequest\Application\Chart\ChartContainer::RESVEGA_CONTAINERS;
        $containerSummaries = $this->chartContainerService->getContainerSummaries(array_keys($resvegaContainers));

        $containers = [];
        foreach ($resvegaContainers as $id => $container) {
            $container['id'] = $id;

            $summaryIndex = array_search($id, array_column($containerSummaries, 'id'));
            $summary = $containerSummaries[$summaryIndex];
            $container['summary'] = $summary;

            $containers[] = $container;
        }

        $access = $this->getResVegaAccess();

        return new JsonModel(
            [
                'allowed' => $allowed,
                'access' => $access,
                'containers' => $containers
            ]
        );
    }

    private function getResVegaAccess() {
        $accessQuery = $this->em->createQueryBuilder();
        $accessIndicator = $accessQuery
            ->select('system.rfSysTourismTodayAccessInd')
            ->from('Resrequest\DB\Enterprise\Entity\RfSystem', 'system')
            ->getQuery()
            ->getSingleScalarResult();

        return intval($accessIndicator);
    }
}
