<?php
namespace Resrequest\API\V1\Rpc\ResVegaSetAccess;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;
use ZF\ContentNegotiation\ViewModel;

class ResVegaSetAccessController extends AbstractActionController
{
    private $em;
    protected $password;

    public function __construct($em, $enterprise) {
        $this->em = $em;
        $this->password = $enterprise->passwords['resvegaSetAccess'];
    }

    public function resVegaSetAccessAction()
    {
        $params = $this->bodyParams();

        if (!isset($params['securityHash']) || $params['securityHash'] !== $this->password) {
            return new ViewModel(['data' => '', 'error' => 'Invalid security hash', 'code' => 401]); // Unauthorized
        }

        $access = $params['access'];
        
        $this->setResVegaAccess($access);

        return new JsonModel([
            'status' => true
        ]);
    }

    private function setResVegaAccess($access) {
        if (is_int($access) && $access >= 0 && $access <= 2) {
            $rfSystem = $this->em->getRepository('Resrequest\DB\Enterprise\Entity\RfSystem')->findBy(['rfSystemId' => 1])[0];

            $rfSystem->setRfSysTourismTodayAccessInd($access);

            $this->em->merge($rfSystem);
            $this->em->flush();

            // When access is removed, clear all users access to the ResVega dashboards
            if ($access === 0) {
                $resVegaContainers = array_keys(\Resrequest\Application\Chart\ChartContainer::RESVEGA_CONTAINERS);

                $removeAccessQuery = $this->em->createQueryBuilder()
                    ->delete()
                    ->from('Resrequest\DB\Enterprise\Entity\ScGroupChartContainer', 'chartContainerAccess')
                    ->where('chartContainerAccess.chChartContainerId IN(:containers)')
                    ->setParameter('containers', $resVegaContainers)
                    ->getQuery();

                return $removeAccessQuery->execute();
            }

            return true;
        } else {
            return false;
        }
    }
}
