<?php
namespace Resrequest\API\V1\Rpc\ResVegaSignUp;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ContentNegotiation\JsonModel;

define('RESVEGA_SIGN_UP_SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))))); //Go back 5 directories
define('RESVEGA_SIGN_UP_ROOT', RESVEGA_SIGN_UP_SERVER. '/Application/src/Resrequest/legacy');

class ResVegaSignUpController extends AbstractActionController
{
    private $em;
    private $auth;

    public function __construct($em, $auth) {
        $this->em = $em;
        $this->auth = $auth;
    }

    public function resVegaSignUpAction()
    {
        $username = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if ($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $this->auth->setupContext($this->auth->getUserByName($username));

        require_once(RESVEGA_SIGN_UP_ROOT . '/class.mysqldb.php');
        require_once(RESVEGA_SIGN_UP_ROOT . '/functions.mail.php');

        $image = realpath(RESVEGA_SIGN_UP_SERVER . '/UI/public/src/assets/images/tourism_today/sign-up-mailer-animation.gif');
        $email = $this->getUsersEmail();
        $version = $this->bodyParams()['version'];
        $versionUpper = strtoupper($version);
        $message = $this->buildEmail($version);
        $failed = email(
            'resvega@resrequest.com',
            "{$email}, {$GLOBALS['support']['email']}",
            "Tourism.Today {$versionUpper} sign up ({$GLOBALS['principal_name']})",
            '',
            $message,
            0,
            0,
            '',
            "ResRequest User",
            '',
            '',
            false,
            false,
            50,
            true,
            [
                [
                    'path' => $image,
                    'cid' => 'sign-up-animation',
                    'name' => 'sign-up-animation.gif'
                ]
            ]
        );

        $response = [
            'success' => !$failed
        ];

        return new JsonModel($response);
    }

    private function getUsersEmail() {
        $email = $this->em
            ->createQueryBuilder()
            ->select('persona.prEmail')
            ->from('Resrequest\DB\Enterprise\Entity\PrPersona', 'persona')
            ->where('persona.prPersonaIx = :prUserId')
            ->setParameter('prUserId', $GLOBALS['pr_user_id'])
            ->getQuery()
            ->getSingleScalarResult();

        return $email;
    }

    private function buildEmail($version){
        if ($version == 'free') {
            $template = file_get_contents(RESVEGA_SIGN_UP_SERVER . '/Application/public/html/template_resvega_sign_up_free.htm');
        } else {
            $template = file_get_contents(RESVEGA_SIGN_UP_SERVER . '/Application/public/html/template_resvega_sign_up_pro.htm');
        }

        $temp = [];
        $temp['username'] = $this->getIdentity()->getAuthenticationIdentity()['user_id'];
        $temp['principalId'] = $GLOBALS['principal_id'];
        $temp['principalName'] = $GLOBALS['principal_name'];
        $temp['email'] = $this->getUsersEmail();

        if ($GLOBALS['sc_group_id'] == 5) {
            $temp['administrator'] = 'Yes';
        } else {
            $temp['administrator'] = 'No';
        }

        foreach ($temp as $key => $value){
            $template = str_replace("!$key!", $value, $template);
        }

        return $template;
    }

    private function response($data) {
        return new JsonModel($data);
    }
}
