<?php
namespace Resrequest\API\V1\Rpc\ReservationGetReservation;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

define('RESERVATION_GET_RESERVATION_SERVER' , dirname(dirname(dirname(dirname(dirname(dirname(dirname(dirname(__FILE__))))))))); //Go back 5 directories
define('RESERVATION_GET_RESERVATION_ROOT', RESERVATION_GET_RESERVATION_SERVER. '/Application/src/Resrequest/legacy');
require_once(RESERVATION_GET_RESERVATION_ROOT . '/inc.setup.php');

class ReservationGetReservationController extends AbstractActionController
{
    protected $em;
    protected $authorise;
    protected $db;

    public function __construct($em, $authorise)
    {
      $this->em = $em;
      $this->authorise = $authorise;
      $this->dbcode = $GLOBALS['dbcode'];
      $this->db = $this->em->getConnection();
    }

    public function reservationGetReservationAction()
    {
      $params = $this->bodyParams();

      $username = false;
      $identity = $this->getIdentity();
      if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
          $username = $identity->getAuthenticationIdentity()['user_id'];
      }

      if($username === false) {
          return new ApiProblemResponse(
              new ApiProblem(403, "Unable to find user")
          );
      }
      $userQuery = $this->em->createQueryBuilder();
      $user = $userQuery
        ->select(
          [
            'pr_user.prUserId',
            'sc_user.scGroupId'
          ]
        )
        ->from('Resrequest\DB\Enterprise\Entity\ScUser', 'sc_user')
        ->innerJoin('Resrequest\DB\Enterprise\Entity\PrUser', 'pr_user', 'with', 'pr_user.prUserId = sc_user.prUserId')
        ->where('pr_user.prUserName = :pr_user_name')
        ->setParameters(
          [ 'pr_user_name' => $username ]
        )
        ->setMaxResults(1)
        ->getQuery()
        ->getOneOrNullResult();
      if($user === null) {
          return new ApiProblemResponse(
              new ApiProblem(403, "Unable to find user")
          );
      }
    }
}
