<?php
namespace Resrequest\API\V1\Rpc\RoomingGetDefaultRate;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class RoomingGetDefaultRateController extends AbstractActionController
{
    protected $em;

    public function __construct($em)
    {
        $this->em = $em;
    }

    public function roomingGetDefaultRateAction()
    {

        $db = $this->em->getConnection();
        $rate = $db->fetchAssoc("
            SELECT
                rt_rate_type.rt_rate_type_ix,
                rt_rate_type.rt_rate_type_desc,
                rf_currency.rf_currency_symbol
            FROM
                rf_default
                INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rf_default.rt_rate_type_id
                INNER JOIN rf_currency ON rf_currency.rf_currency_ix = rt_rate_type.rf_currency_id
        ");
        if($rate === false) {
            return new ApiProblemResponse(
                new ApiProblem(500, "Unable to find default rate")
            );
        }

        return new JsonModel([
            'id'=>$rate['rt_rate_type_ix'],
            'name'=>$rate['rt_rate_type_desc'],
            'currency'=>$rate['rf_currency_symbol']
        ]);
    }
}
