<?php

namespace Resrequest\API\V1\Rpc\RoomingGetItems;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class RoomingGetItemsController extends AbstractActionController
{
    protected $em;
    protected $authorise;

    public function __construct($em, $authorise)
    {
        $this->em = $em;
        $this->authorise = $authorise;
    }

    public function roomingGetItemsAction()
    {
        $params = $this->bodyParams();
        $db = $this->em->getConnection();
        //    $db->getConfiguration()->setSQLLogger(new ErrorSQLLogger());

        $username = false;
        $identity = $this->getIdentity();
        if ($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if ($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $user = $db->fetchAssoc("
            SELECT
                pr_user.pr_user_id,
                sc_user.sc_group_id
            FROM
                sc_user
                INNER JOIN pr_user ON pr_user.pr_user_id = sc_user.pr_user_id
            WHERE
                pr_user.pr_user_name = ?
        ", [$username]);
        if ($user === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $access = $this->authorise->getAccess([
            'functions' => [81]
        ]);
        if (!isset($access['functions'][81]) || $access['functions'][81] < 5) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Access denied")
            );
        }

        if (
            !array_key_exists("accomm_filter", $params)
            || !is_array($params['accomm_filter'])
            || sizeof($params['accomm_filter']) == 0
            || empty($params['accomm_filter'][0])
        ) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid accommodation type filter")
            );
        }
        $accommFilter = $params['accomm_filter'];

        if (
            !array_key_exists("period", $params)
            || !is_array($params['period'])
            || !array_key_exists("from", $params['period'])
            || !array_key_exists("to", $params['period'])
        ) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid period")
            );
        }
        $fromDate = $params['period']['from'];
        $toDate = $params['period']['to'];

        $accommACL = array_column($db->fetchAll("
            SELECT DISTINCT
                ac_accomm_type.ac_accomm_type_ix
            FROM
                sc_accomm
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
                INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
            WHERE
                sc_accomm.sc_group_id = ?
                AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
                AND ac_accomm_type.ac_accomm_type_ix IN (?)
                AND pr_business.pr_bus_inactive_yn = '0'
        ", [
            $user['sc_group_id'],
            $accommFilter
        ], [
            \PDO::PARAM_INT,
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY
        ]), 'ac_accomm_type_ix');

        $properties = $db->fetchAll("
            SELECT DISTINCT
                ac_accomm_type.pr_business_id
            FROM
                ac_accomm_type
            WHERE
                ac_accomm_type.ac_accomm_type_ix IN (?)
        ", [
            $accommACL,
        ], [
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY,
        ]);

        $items = array_fill_keys(array_map(function ($item) {
            return $item['pr_business_id'];
        }, $properties), []);

        // Room blocks
        $blocks = $db->fetchAll("
            SELECT
                'block' AS 'type',
                ac_accomm_block.ac_accomm_block_ix AS 'parent_id',
                ac_accomm_room_block.ac_accomm_room_block_ix AS 'id',
                ac_accomm_room_block.ac_accomm_room_id AS 'room_id',
                ac_accomm_block.ac_start_date AS 'from',
                ac_accomm_block.ac_end_date AS 'to',
                ac_accomm_type.pr_business_id AS 'property_id'
            FROM
                ac_accomm_room_block
                INNER JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = ac_accomm_room_block.ac_accomm_room_id
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
                INNER JOIN ac_accomm_block ON ac_accomm_block.ac_accomm_block_ix = ac_accomm_room_block.ac_accomm_block_id
            WHERE
                ac_accomm_type.ac_accomm_type_ix IN (?)
                AND (
                    (
                        ac_accomm_block.ac_start_date >= ?
                        AND ac_accomm_block.ac_start_date <= ?
                    ) OR (
                        ac_accomm_block.ac_end_date >= ?
                        AND ac_accomm_block.ac_end_date <= ?
                    ) OR (
                        ac_accomm_block.ac_start_date < ?
                        AND ac_accomm_block.ac_end_date > ?
                    )
                )
            ORDER BY
                ac_accomm_room_block.ac_accomm_room_id,
                ac_accomm_block.ac_start_date,
                ac_accomm_block.ac_end_date
        ", [
            $accommACL,
            $fromDate,
            $toDate,
            $fromDate,
            $toDate,
            $fromDate,
            $toDate
        ], [
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR
        ]);
        // Combine overlapping or adjacent blocks
        $current = false;
        foreach ($blocks as $block) {
            if (
                $current === false
                || $current['room_id'] != $block['room_id']
                || $current['to'] < $block['from']
            ) {
                $current = &$items[$block['property_id']][];
                $current = $block;
                continue;
            }
            if ($current['from'] > $block['from']) {
                $current['from'] = $block['from'];
            }
            if ($current['to'] < $block['to']) {
                $current['to'] = $block['to'];
            }
        }
        unset($current);

        // Rooms newly created
        $roomsCreated = $this->em->getConnection()->fetchAll("
            SELECT
                'block' AS 'type',
                ac_accomm_type.ac_accomm_type_ix AS 'parent_id',
                ac_accomm_room.ac_accomm_room_ix AS 'id',
                ac_accomm_room.ac_accomm_room_ix AS 'room_id',
                '$fromDate' AS 'from',
                ac_accomm_room.ac_accomm_room_create_date AS 'to',
                'Room not yet created' AS 'name',
                ac_accomm_type.pr_business_id AS 'property_id'
            FROM
                ac_accomm_room
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
                INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
                INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
            WHERE
                ac_accomm_type.ac_accomm_type_ix IN (?)
                AND ac_accomm_room.ac_accomm_room_create_date > '$fromDate'
                AND ac_accomm_room.ac_accomm_room_create_date < '$toDate'
            ORDER BY
                pr_business.pr_business_sequence,
                pr_business.pr_business_id
        ", [$accommACL], [\Doctrine\DBAL\Connection::PARAM_STR_ARRAY]);
        foreach ($roomsCreated as $roomCreatedItem) {
            $items[$roomCreatedItem['property_id']][] = $roomCreatedItem;
        }

        // Rooms made inactive
        $roomsInactive = $this->em->getConnection()->fetchAll("
            SELECT
                'block' AS 'type',
                ac_accomm_type.ac_accomm_type_ix AS 'parent_id',
                ac_accomm_room.ac_accomm_room_ix AS 'id',
                ac_accomm_room.ac_accomm_room_ix AS 'room_id',
                ac_accomm_room.ac_accomm_room_inactive_date AS 'from',
                '$toDate' AS 'to',
                'Room inactive' AS 'name',
                ac_accomm_type.pr_business_id AS 'property_id'
            FROM
                ac_accomm_room
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
                INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
                INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
            WHERE
                ac_accomm_type.ac_accomm_type_ix IN (?)
                AND ac_accomm_room.ac_accomm_room_inactive_yn != '0'
                AND ac_accomm_room.ac_accomm_room_inactive_date > '$fromDate'
                AND ac_accomm_room.ac_accomm_room_inactive_date < '$toDate'
            ORDER BY
                pr_business.pr_business_sequence,
                pr_business.pr_business_id
        ", [$accommACL], [\Doctrine\DBAL\Connection::PARAM_STR_ARRAY]);
        foreach ($roomsInactive as $roomInactiveItem) {
            $items[$roomInactiveItem['property_id']][] = $roomInactiveItem;
        }

        $wizResId = isset($_SESSION['wizResId']) ? $_SESSION['wizResId'] : "";

        $dbBusiness = $db->fetchAll("
            SELECT DISTINCT pr_business_id, rf_db_code FROM rf_db_business
        ");

        $propertyMap = [];

        foreach ($dbBusiness as $row) {
            $propertyMap[$row['pr_business_id']] = $row['rf_db_code'];
        }

        // Allocated
        $allocated = $db->fetchAll("
            SELECT
                IF(ac_accomm_room.ac_accomm_room_ix IS NULL,'unallocated','allocated') AS 'type',
                rv_reservation_item.rv_reservation_item_ix AS 'parent_id',
                rv_res_item_group.rv_res_item_group_ix AS 'id',
                rv_res_item_group.ac_accomm_room_id AS 'room_id',
                IF(ac_accomm_room.ac_desc IS NULL, '', ac_accomm_room.ac_desc) AS 'room_name',
                rv_res_item_group.rv_grp_status_ind AS 'room_status_ind',
                rv_res_item_group.rv_grp_status_time AS 'room_status_time',
                rv_res_item_group.rv_room_requested_yn AS 'requested_yn',
                rv_res_item_group.rv_room_request_reason AS 'requested_reason',
                rv_reservation_item.rv_item_accomm_count AS 'accomm_count',
                rv_reservation_item.rv_item_adult_count AS 'adult_count',
                rv_reservation_item.rv_item_child_count AS 'child_count',
                rv_reservation_item.ac_accomm_type_id AS 'accomm_id',
                ac_accomm_type.ac_accomm_max_capacity AS 'room_max_capacity',
                ac_accomm_type.ac_accomm_desc AS 'accomm_name',
                real_accomm_type.ac_accomm_type_ix AS 'real_accomm_id',
                real_accomm_type.ac_accomm_desc AS 'real_accomm_name',
                rv_reservation_item.pr_business_id AS 'property_id',
                pr_persona.pr_name_last AS 'property_name',
                rv_reservation_item.rv_item_date_arrive AS `from`,
                DATE_FORMAT(IF(
                    rv_res_item_group.rv_grp_status_ind = '8', rv_res_item_group.rv_grp_status_time,
                    IF(
                        rv_res_item_group.rv_grp_status_ind = '5',
                            IF(DATE(NOW()) > rv_reservation_item.rv_item_date_depart,
                                DATE(NOW()),
                                rv_reservation_item.rv_item_date_depart
                            ),
                            rv_reservation_item.rv_item_date_depart
                    )
                ), '%Y-%m-%d') AS `to`,
                rv_reservation_item.rv_item_date_depart AS 'to_booked',
                rv_reservation.rv_reservation_ix AS 'reservation_id',
                rv_reservation.rv_res_name AS 'name',
                rv_reservation.rf_reservation_status_id AS 'status_id',
                rf_reservation_status.rf_reservation_status_desc AS 'status_name',
                rv_reservation.rv_provision_expiry_date AS 'status_prov_expiry',
                IF(rv_reservation.rv_reservation_ix = '$wizResId', 1, 0) AS 'status_booking_yn',
                rv_reservation.rv_create_expiry_date AS 'status_create_expiry',
                rt_rate_type.rt_rate_type_ix AS 'rate_type_id',
                rt_rate_type.rt_rate_type_desc AS 'rate_type_name',
                IF(pr_persona_agent.pr_persona_ix IS NULL,'0',pr_persona_agent.pr_persona_ix) AS 'agent_id',
                IF(pr_persona_agent.pr_persona_ix IS NULL,'Direct',CONCAT_WS(' ', pr_persona_agent.pr_name_first,pr_persona_agent.pr_name_last)) AS 'agent_name',
                GROUP_CONCAT(CONCAT_WS('%/$', pr_persona_guest.pr_name_first,pr_persona_guest.pr_name_last) SEPARATOR '%$') AS 'guest_names',
                GROUP_CONCAT(rv_res_item_guest.pr_guest_id SEPARATOR '%$') AS 'guest_ids',
                rv_reservation.rv_agent_ref AS 'voucher'
            FROM
                rv_res_item_group
                INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_item_ix = rv_res_item_group.rv_reservation_item_id
                INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
                INNER JOIN rv_reservation ON rv_reservation.rv_reservation_ix = rv_reservation_item.rv_reservation_id
                INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
                INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
                LEFT JOIN pr_persona AS pr_persona_agent ON pr_persona_agent.pr_persona_ix = rv_reservation.rv_agent_id
                LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
                LEFT JOIN ac_accomm_type AS real_accomm_type ON real_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
                LEFT JOIN rv_res_item_guest ON rv_res_item_guest.rv_res_item_group_id = rv_res_item_group.rv_res_item_group_ix
                LEFT JOIN pr_persona AS pr_persona_guest ON pr_persona_guest.pr_persona_ix = rv_res_item_guest.pr_guest_id
            WHERE
                (
                    rv_reservation_item.ac_accomm_type_id IN (?)
                    OR real_accomm_type.ac_accomm_type_ix IN (?)
                )
                AND (
                    rv_res_item_group.rv_grp_status_ind = 5
                    OR rv_reservation.rf_reservation_status_id = '30'
                    OR (
                        rv_reservation.rf_reservation_status_id = '25'
                        AND rv_reservation.rv_create_expiry_date >= '" . date("Y-m-d H:i:s") . "'
                    ) OR (
                        rv_reservation.rf_reservation_status_id = '20'
                        AND (
                            rv_reservation.rv_provision_expiry_date >= '" . date("Y-m-d") . "'
                            OR rv_res_item_group.ac_accomm_room_id <> '0'
                        )
                    ) OR (
                        rv_reservation.rf_reservation_status_id = '0'
                        AND rv_res_item_group.ac_accomm_room_id <> '0'
                        )
                ) AND (
                    ac_accomm_room.ac_accomm_room_ix IS NULL
                    OR ac_accomm_room.ac_accomm_type_id IN (?)
                )
            GROUP BY
                rv_res_item_group.rv_res_item_group_ix
            HAVING
                (
                    (
                        `from` >= ?
                        AND `from` <= ?
                    ) OR (
                        `to` >= ?
                        AND `to` <= ?
                    ) OR (
                        `from` < ?
                        AND `to` > ?
                    )
                )
        ", [
            $accommACL,
            $accommACL,
            $accommACL,
            $fromDate,
            $toDate,
            $fromDate,
            $toDate,
            $fromDate,
            $toDate
        ], [
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY,
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY,
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR
        ]);

        $statusFetched = array();

        foreach ($allocated as $allocatedItem) {
            $item = $allocatedItem;

            if (!in_array($item['real_accomm_id'] . $item['room_id'], $statusFetched)) {
                $currentRoomStatus = $db->fetchAssoc("
                    SELECT
                        rv_grp_status_ind
                    FROM
                        rv_res_item_group
                    WHERE
                        ac_accomm_type_id = ?
                        AND ac_accomm_room_id = ?
                        AND rv_grp_status_time != ?
                    ORDER BY
                        rv_grp_status_time DESC
                    LIMIT 1
                ", [
                    $item['real_accomm_id'],
                    $item['room_id'],
                    '0000-00-00 00:00:00'
                ]);

                $currentRoomStatus = $currentRoomStatus['rv_grp_status_ind'];
                $statusFetched[$item['real_accomm_id'] . $item['room_id']] = $currentRoomStatus;
            } else {
                $key = $item['real_accomm_id'] . $item['room_id'];
                $currentRoomStatus = isset($statusFetched[$key]) ? $statusFetched[$key] : "";
            }

            $guests = [];
            $guestNames = explode('%$', $item['guest_names']);
            $guestNames = array_map(function($name) {
                if (empty($name)) {
                    return false;
                }
                
                $names = explode('%/$', $name);

                return ['firstName' => $names[0], 'lastName' => $names[1]];
            }, $guestNames);

            $guestIds = explode('%$', $item['guest_ids']);

            foreach ($guestIds as $index => $id) {
                if (!empty($id) && $guestNames[$index]) {
                    $guests[] = ['firstName' => $guestNames[$index]['firstName'], 'lastName' => $guestNames[$index]['lastName'], 'id' => $id];
                }
            }

            unset($item['guest_names']);
            unset($item['guest_ids']);

            $item['guests'] = $guests;

            // Convert string to int
            $item['room_status_ind'] = intval($item['room_status_ind']);
            $item['current_room_status_ind'] = intval($currentRoomStatus);
            $item['requested_yn'] = intval($item['requested_yn']);
            $item['room_max_capacity'] = intval($item['room_max_capacity']);

            if (array_key_exists($item['property_id'], $propertyMap)) {
                $item['access_environment'] = $propertyMap[$item['property_id']];
            } else {
                $item['access_environment'] = '';
            }

            $items[$allocatedItem['property_id']][] = $item;
        }

        // Unallocated
        $unallocated = $db->fetchAll("
            SELECT
                'unallocated' AS 'type',
                rv_reservation_item.rv_reservation_item_ix AS 'parent_id',
                '' AS 'id',
                '' AS 'room_id',
                '' AS 'room_name',
                '2' AS 'room_status_ind',
                '' AS 'room_status_time',
                '' AS 'requested_yn',
                '' AS 'requested_reason',
                rv_reservation_item.rv_item_date_arrive AS 'from',
                rv_reservation_item.rv_item_date_depart AS 'to',
                rv_reservation_item.rv_item_date_depart AS 'to_booked',
                rv_reservation_item.rv_item_accomm_count AS 'accomm_count',
                rv_reservation_item.rv_item_adult_count AS 'adult_count',
                rv_reservation_item.rv_item_child_count AS 'child_count',
                rv_reservation_item.ac_accomm_type_id AS 'accomm_id',
                ac_accomm_type.ac_accomm_desc AS 'accomm_name',
                '' AS 'real_accomm_id',
                '' AS 'real_accomm_name',
                ac_accomm_type.ac_accomm_max_capacity AS 'room_max_capacity',
                rv_reservation_item.pr_business_id AS 'property_id',
                pr_persona.pr_name_last AS 'property_name',
                rv_reservation.rv_reservation_ix AS 'reservation_id',
                rv_reservation.rv_res_name AS 'name',
                rv_reservation.rf_reservation_status_id AS 'status_id',
                rf_reservation_status.rf_reservation_status_desc AS 'status_name',
                rv_reservation.rv_provision_expiry_date AS 'status_prov_expiry',
                IF(rv_reservation.rv_reservation_ix = '$wizResId', 1, 0) AS 'status_booking_yn',
                rv_reservation.rv_create_expiry_date AS 'status_create_expiry',
                rt_rate_type.rt_rate_type_ix AS 'rate_type_id',
                rt_rate_type.rt_rate_type_desc AS 'rate_type_name',
                IF(pr_persona_agent.pr_persona_ix IS NULL,'0',pr_persona_agent.pr_persona_ix) AS 'agent_id',
                IF(pr_persona_agent.pr_persona_ix IS NULL,'Direct',CONCAT_WS(' ', pr_persona_agent.pr_name_first,pr_persona_agent.pr_name_last)) AS 'agent_name',
                (rv_reservation_item.rv_item_accomm_count - COUNT(rv_res_item_group.rv_res_item_group_ix)) AS items,
                rv_reservation.rv_agent_ref AS 'voucher',
                '' AS 'access_environment'
            FROM
                rv_reservation
                INNER JOIN rf_reservation_status ON rf_reservation_status.rf_reservation_status_id = rv_reservation.rf_reservation_status_id
                INNER JOIN rt_rate_type ON rt_rate_type.rt_rate_type_ix = rv_reservation.rt_rate_type_id
                LEFT JOIN pr_persona AS pr_persona_agent ON pr_persona_agent.pr_persona_ix = rv_reservation.rv_agent_id
                INNER JOIN rv_reservation_item ON rv_reservation_item.rv_reservation_id = rv_reservation.rv_reservation_ix
                INNER JOIN pr_persona ON pr_persona.pr_persona_ix = rv_reservation_item.pr_business_id
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = rv_reservation_item.ac_accomm_type_id
                LEFT JOIN rv_res_item_group ON rv_res_item_group.rv_reservation_item_id = rv_reservation_item.rv_reservation_item_ix
                LEFT JOIN ac_accomm_room ON ac_accomm_room.ac_accomm_room_ix = rv_res_item_group.ac_accomm_room_id
            WHERE
                rv_reservation_item.ac_accomm_type_id IN (?)
                AND (
                    rv_reservation.rf_reservation_status_id = '30'
                    OR (
                        rv_reservation.rf_reservation_status_id = '25'
                        AND rv_reservation.rv_create_expiry_date >= '" . date("Y-m-d H:i:s") . "'
                    ) OR (
                        rv_reservation.rf_reservation_status_id = '20'
                        AND rv_reservation.rv_provision_expiry_date >= '" . date("Y-m-d") . "'
                    )
                ) AND (
                    (
                        rv_reservation_item.rv_item_date_arrive >= ?
                        AND rv_reservation_item.rv_item_date_arrive <= ?
                    ) OR (
                        rv_reservation_item.rv_item_date_depart >= ?
                        AND rv_reservation_item.rv_item_date_depart <= ?
                    ) OR (
                        rv_reservation_item.rv_item_date_arrive < ?
                        AND rv_reservation_item.rv_item_date_depart > ?
                    )
                )
            GROUP BY
                rv_reservation_item.rv_reservation_item_ix
            HAVING items > 0
        ", [
            $accommACL,
            $fromDate,
            $toDate,
            $fromDate,
            $toDate,
            $fromDate,
            $toDate
        ], [
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR,
            \PDO::PARAM_STR
        ]);
        foreach ($unallocated as $item) {
            $total = $item['items'];
            unset($item['items']);
            $item['guests'] = [];

            // Convert string to int
            $item['room_status_ind'] = intval($item['room_status_ind']);
            $item['current_room_status_ind'] = intval("2");
            $item['requested_yn'] = intval($item['requested_yn']);
            $item['room_max_capacity'] = intval($item['room_max_capacity']);

            for ($count = 0; $count < $total; $count++) {
                $items[$item['property_id']][] = $item;
            }
        }

        return new JsonModel($items);
    }
}
