<?php
namespace Resrequest\API\V1\Rpc\RoomingGetRateAmount;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class RoomingGetRateAmountController extends AbstractActionController
{
    protected $em;
    protected $auth;
    protected $legacy;

    public function __construct($em, $auth)
    {
        $this->em = $em;
        $this->auth = $auth;
        $this->legacy = __DIR__."/../../../../../../../Application/src/Resrequest/legacy/";
    }

    public function roomingGetRateAmountAction()
    {
        $params = $this->bodyParams();
        $db = $this->em->getConnection();

        $username = false;
        $identity = $this->getIdentity();
        if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $this->auth->setupContext($this->auth->getUserByName($username));

        $user = $db->fetchAssoc("
            SELECT
                pr_user.pr_user_id,
                sc_user.sc_group_id
            FROM
                sc_user
                INNER JOIN pr_user ON pr_user.pr_user_id = sc_user.pr_user_id
            WHERE
                pr_user.pr_user_name = ?
        ",[$username]);
        if($user === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $accommFilter = array();
        if(
            array_key_exists("accomm_filter",$params)
            && is_array($params['accomm_filter'])
            && sizeof($params['accomm_filter']) > 0
            && !empty($params['accomm_filter'][0])
        ) {
            $accommFilter = $params['accomm_filter'];
        } else {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing accommodation filter")
            );
        }

        if(!array_key_exists("rate_type_id", $params)) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing rate type id")
            );
        }
        $rt_rate_type_id = $params['rate_type_id'];

        require_once($this->legacy . "db.rt_rate_type.php");

		$list = db_rt_rate_type_get_list();

		$found = false;
		foreach($list as $item) {
			if($item['rt_rate_type_ix'] == $rt_rate_type_id) {
				$found = true;
			}
		}
		if(!$found) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid or missing rate type id")
            );
		}

        // TODO agent specific checks and changes (eg. internal user only override, apply comm, etc)

        if(
            !array_key_exists("period",$params)
            || !is_array($params['period'])
            || !array_key_exists("from",$params['period'])
            || !array_key_exists("to",$params['period'])
        ) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid period")
            );
        }
        $fromDate = $params['period']['from'];
        $toDate = $params['period']['to'];

        $accommACL = array_column($db->fetchAll("
            SELECT DISTINCT
                ac_accomm_type.ac_accomm_type_ix
            FROM
                sc_accomm
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
                INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
            WHERE
                sc_accomm.sc_group_id = ?
                AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
                AND ac_accomm_type.ac_accomm_type_ix IN (?)
                AND pr_business.pr_bus_inactive_yn = '0'
        ",[
            $user['sc_group_id'],
            $accommFilter
        ],[
            \PDO::PARAM_INT,
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY
        ]),'ac_accomm_type_ix');

        require_once($this->legacy . "class.rate.standard.php");

		$accomm_types = $db->fetchAll("
			SELECT
				ac_accomm_type.ac_accomm_type_ix,
				ac_accomm_type.ac_accomm_capacity
			FROM
				ac_accomm_type
			WHERE
				ac_accomm_type.ac_accomm_type_ix IN (?)
        ",[
            $accommACL
        ],[
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY
        ]);

		$unitRateGroup = $db->fetchColumn("
			SELECT
				rt_rate_group_ix
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 1
		");

		$adultRateGroup = $db->fetchColumn("
			SELECT
				rt_rate_group_ix
			FROM
				rt_rate_group
			WHERE
				rt_rate_group.rt_rate_group_sys_code = 2
		");

        $list = [];
		foreach ($accomm_types as $ac_accomm_type){
            $rateGroups = [];

			$rateGroups[] = array(
						"rt_rate_group_ix" => $unitRateGroup,
						"name"	=> "Units",
						"qty"	=> 1);
			$rateGroups[] = array(
						"rt_rate_group_ix" => $adultRateGroup,
						"name"	=> "Adults",
						"qty"	=> $ac_accomm_type['ac_accomm_capacity']);

			$dateSpan = new \DatePeriod(
				 new \DateTime($fromDate),
				 new \DateInterval('P1D'),
				 new \DateTime($toDate)
			);

            $days = [];
			foreach ($dateSpan as $date) {
                $day = $date->format("Y-m-d");
                $date->modify('+1 day');
                $nextDay = $date->format("Y-m-d");

                $rate = new \Rate($ac_accomm_type['ac_accomm_type_ix'],$day,$nextDay,$rateGroups,$rt_rate_type_id);
                $periods = $rate->ToPeriods();

                if(!empty($rate->Periods[0]['rv_item_amt_gross'])) {
                    $days[$day] = $rate->Periods[0]['rv_item_amt_gross'];
                } else {
                    $days[$day] = "TBA";
                }
            }

            $list[] = [
                'accommodation_id' => $ac_accomm_type['ac_accomm_type_ix'],
                'rate_amounts' => $days
            ];
		}

        return new JsonModel($list);
    }
}
