<?php
namespace Resrequest\API\V1\Rpc\RoomingGetRooms;

use Zend\Mvc\Controller\AbstractActionController;
use ZF\ApiProblem\ApiProblemResponse;
use ZF\ApiProblem\ApiProblem;
use ZF\ContentNegotiation\JsonModel;

class RoomingGetRoomsController extends AbstractActionController
{
    protected $em;
    protected $authorise;

    public function __construct($em, $authorise)
    {
        $this->em = $em;
        $this->authorise = $authorise;
    }

    public function roomingGetRoomsAction()
    {
        $params = $this->bodyParams();
        $db = $this->em->getConnection();

        $username = false;
        $identity = $this->getIdentity();
        if($identity instanceof \ZF\MvcAuth\Identity\AuthenticatedIdentity) {
            $username = $identity->getAuthenticationIdentity()['user_id'];
        }

        if($username === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $user = $db->fetchAssoc("
            SELECT
                pr_user.pr_user_id,
                sc_user.sc_group_id
            FROM
                sc_user
                INNER JOIN pr_user ON pr_user.pr_user_id = sc_user.pr_user_id
            WHERE
                pr_user.pr_user_name = ?
        ",[$username]);
        if($user === false) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Unable to find user")
            );
        }

        $access = $this->authorise->getAccess([
            'functions'=>[81]
        ]);
        if(!isset($access['functions'][81]) || $access['functions'][81] < 5) {
            return new ApiProblemResponse(
                new ApiProblem(403, "Access denied")
            );
        }

        $accommFilter = array();
        if(
            array_key_exists("accomm_filter",$params)
            && is_array($params['accomm_filter'])
            && sizeof($params['accomm_filter']) > 0
            && !empty($params['accomm_filter'][0])
        ) {
            $accommFilter = $params['accomm_filter'];
        } else {
            $firstProperty = $db->fetchColumn("
                SELECT DISTINCT
                    pr_business.pr_business_id
                FROM
                    sc_accomm
                    INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
                    INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
                WHERE
                    sc_accomm.sc_group_id = ?
                    AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
                    AND pr_business.pr_bus_inactive_yn = '0'
                LIMIT 1
            ",[$user['sc_group_id']]);
            $accommFilter = array_column($db->fetchAll("
                SELECT DISTINCT
                    ac_accomm_type.ac_accomm_type_ix
                FROM
                    sc_accomm
                    INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
                    INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
                WHERE
                    sc_accomm.sc_group_id = ?
                    AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
                    AND pr_business.pr_bus_inactive_yn = '0'
                    AND pr_business.pr_business_id = ?
            ",[$user['sc_group_id'],$firstProperty]),'ac_accomm_type_ix');
        }

        $accommACL = array_column($db->fetchAll("
            SELECT DISTINCT
                ac_accomm_type.ac_accomm_type_ix
            FROM
                sc_accomm
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = sc_accomm.ac_accomm_type_id
                INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
            WHERE
                sc_accomm.sc_group_id = ?
                AND ac_accomm_type.ac_accomm_type_inactive_yn = '0'
                AND ac_accomm_type.ac_accomm_type_ix IN (?)
                AND pr_business.pr_bus_inactive_yn = '0'
        ",[
            $user['sc_group_id'],
            $accommFilter
        ],[
            \PDO::PARAM_INT,
            \Doctrine\DBAL\Connection::PARAM_STR_ARRAY
        ]),'ac_accomm_type_ix');

        if(
            !array_key_exists("period",$params)
            || !is_array($params['period'])
            || !array_key_exists("from",$params['period'])
            || !array_key_exists("to",$params['period'])
        ) {
            return new ApiProblemResponse(
                new ApiProblem(400, "Invalid period")
            );
        }
        $fromDate = $params['period']['from'];
        $toDate = $params['period']['to'];


        if(
            !array_key_exists("sort_by",$params)
            || $params['sort_by'] != "room"
        ) {
            $orderBy = "
                ac_accomm_type.ac_accomm_sequence,
                ac_accomm_type.ac_accomm_desc,
                ac_accomm_type.ac_accomm_type_ix,
                (ac_accomm_room.ac_desc+0),
                ac_accomm_room.ac_desc
            ";
        } else {
            $orderBy = "
                (ac_accomm_room.ac_desc+0),
                ac_accomm_room.ac_desc,
                ac_accomm_type.ac_accomm_desc,
                ac_accomm_type.ac_accomm_type_ix
            ";
        }

        $rooms = $this->em->getConnection()->fetchAll("
            SELECT
                ac_accomm_room.ac_accomm_room_ix,
                ac_accomm_room.ac_desc,
                ac_accomm_type.ac_accomm_type_ix,
                ac_accomm_type.ac_accomm_desc,
                pr_business.pr_business_id,
                pr_persona.pr_name_last
            FROM
                ac_accomm_room
                INNER JOIN ac_accomm_type ON ac_accomm_type.ac_accomm_type_ix = ac_accomm_room.ac_accomm_type_id
                INNER JOIN pr_business ON pr_business.pr_business_id = ac_accomm_type.pr_business_id
                INNER JOIN pr_persona ON pr_persona.pr_persona_ix = ac_accomm_type.pr_business_id
            WHERE
                ac_accomm_type.ac_accomm_type_ix IN (?)
                AND ac_accomm_room.ac_accomm_room_create_date < '$toDate'
                AND (
                    ac_accomm_room.ac_accomm_room_inactive_yn = '0'
                    OR (
                        ac_accomm_room.ac_accomm_room_inactive_yn != '0'
                        AND ac_accomm_room.ac_accomm_room_inactive_date > '$fromDate'
                    )
                )
            ORDER BY
                pr_business.pr_business_sequence,
                pr_persona.pr_name_last,
                pr_business.pr_business_id,
                $orderBy
        ",[$accommACL],[\Doctrine\DBAL\Connection::PARAM_STR_ARRAY]);

        $list = [];
        foreach($rooms as $item) {
           $pr_business_id = $item['pr_business_id'];
            if(!array_key_exists($pr_business_id,$list)) {
                $list[$pr_business_id] = [
                    'id'=>$pr_business_id,
                    'name'=>$item['pr_name_last'],
                    'accommodation'=>[],
                    'rooms'=>[]
                ];
            }
            $property =& $list[$pr_business_id];

            $property['rooms'][] = [
                'id'=>$item['ac_accomm_room_ix'],
                'name'=>$item['ac_desc'],
                'accommodation_id'=>$item['ac_accomm_type_ix']
            ];

            $ac_accomm_type_id = $item['ac_accomm_type_ix'];
            if(!array_key_exists($ac_accomm_type_id,$property['accommodation'])) {
                $property['accommodation'][$ac_accomm_type_id] = [
                    'id'=>$ac_accomm_type_id,
                    'name'=>$item['ac_accomm_desc'],
                ];
            }

            unset($property);
        }

        $newList = [];
        foreach($list as $property) {
            $newAccomm = [];
            foreach($property['accommodation'] as $accomm) {
                $newAccomm[] = $accomm;
            }
            $property['accommodation'] = $newAccomm;
            unset($newAccomm);

            $newRooms = [];
            foreach($property['rooms'] as $room) {
                $newRooms[] = $room;
            }
            $property['rooms'] = $newRooms;
            unset($newRooms);

            $newList[] = $property;
        }
        $list = $newList;
        unset($newList);

        return new JsonModel($list);

    }
}
